/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectableContext;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public class AggregationContextImpl
implements AggregationContext {
    private final AspectableContext ctx;
    private final String aspectId;
    private final String channelId;
    private final Consumer<ValidationMessage> msgHandler;

    public AggregationContextImpl(AspectableContext ctx, String aspectId, String channelId, Consumer<ValidationMessage> msgHandler) {
        this.ctx = ctx;
        this.aspectId = aspectId;
        this.channelId = channelId;
        this.msgHandler = msgHandler;
    }

    public void validationMessage(Severity severity, String message, Set<String> artifactIds) {
        this.msgHandler.accept(new ValidationMessage(this.aspectId, severity, message, artifactIds));
    }

    public Collection<ArtifactInformation> getArtifacts() {
        return Collections.unmodifiableCollection(this.ctx.getArtifacts().values());
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Map<MetaKey, String> getChannelMetaData() {
        return Collections.unmodifiableMap(this.ctx.getChannelProvidedMetaData());
    }

    public void createCacheEntry(String id, String name, String mimeType, IOConsumer<OutputStream> creator) throws IOException {
        this.ctx.createCacheEntry(new MetaKey(this.aspectId, id), name, mimeType, creator);
    }

    public boolean streamArtifact(String artifactId, ChannelService.ArtifactReceiver receiver) throws IOException {
        ArtifactInformation artifact = this.ctx.getArtifacts().get(artifactId);
        if (artifact == null) {
            return false;
        }
        return this.ctx.stream(artifactId, (IOConsumer<InputStream>)((IOConsumer)stream -> receiver.consume(artifact, stream)));
    }

    public boolean streamArtifact(String artifactId, IOConsumer<InputStream> consumer) throws IOException {
        return this.ctx.stream(artifactId, consumer);
    }
}

