/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.collection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.utils.lang.Pair;

public class MapBuilder<Key, Value> {
    private final Map<Key, Value> map;

    public MapBuilder(Map<Key, Value> map) {
        this.map = new HashMap<Key, Value>(map);
    }

    public MapBuilder() {
        this.map = new HashMap<Key, Value>(0);
    }

    public final MapBuilder<Key, Value> put(Key key, Value value) {
        this.map.put(key, value);
        return this;
    }

    public final MapBuilder<Key, Value> putAll(Map<Key, Value> values) {
        this.map.putAll(values);
        return this;
    }

    public final MapBuilder<Key, Value> clear() {
        this.map.clear();
        return this;
    }

    public final Map<Key, Value> getMap() {
        return this.map;
    }

    public Map<Key, Value> build() {
        return new HashMap<Key, Value>(this.map);
    }

    public static <Key, Value> Map<Key, Value> toMap(Pair<Key, Value> pair) {
        return MapBuilder.toMap(null, pair);
    }

    public static <Key, Value> Map<Key, Value> toMap(Map<Key, Value> map, Pair<Key, Value> pair) {
        if (map == null) {
            map = new HashMap<Key, Value>(1);
        }
        map.put(pair.first, pair.second);
        return map;
    }
}

