/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.exec;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.scada.utils.exec.Operation;
import org.eclipse.scada.utils.exec.OperationResult;
import org.eclipse.scada.utils.exec.OperationResultHandler;

public abstract class SyncBasedOperation<R, T>
implements Operation<R, T> {
    private static Executor defaultExecutor = Executors.newCachedThreadPool();
    private Executor executor = null;

    private void performJob(OperationResult<R> or, T arg0) {
        try {
            Object result = this.execute(arg0);
            or.notifySuccess(result);
        }
        catch (Exception e) {
            or.notifyFailure(e);
        }
    }

    public SyncBasedOperation() {
        this(defaultExecutor);
    }

    public SyncBasedOperation(Executor executor) {
        this.executor = executor;
    }

    private void startExecute(final OperationResult<R> or, final T arg0) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                SyncBasedOperation.this.performJob(or, arg0);
            }
        });
    }

    @Override
    public OperationResult<R> startExecute(T arg0) {
        OperationResult or = new OperationResult();
        this.startExecute(or, arg0);
        return or;
    }

    @Override
    public OperationResult<R> startExecute(OperationResultHandler<R> handler, T arg0) {
        OperationResult<R> or = new OperationResult<R>(handler);
        this.startExecute(or, arg0);
        return or;
    }
}

