/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/version")
@Api
public interface Version {
    public static final String API_VERSION = "0.3";

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/api")
    @ApiOperation(value="Get the version of the API", notes="This returns the version of the API")
    public String versionText();

    @GET
    @Produces(value={"application/json"})
    @Path(value="/product")
    @ApiOperation(value="Get the different version informations of this instance", notes="Fetch all different kind of version information about this installation")
    public ProductVersion productVersionJson();

    @ApiModel(description="Information about the product version")
    public static final class ProductVersion {
        private String productName;
        private String version;
        private String versionUnqualified;
        private String userAgent;
        private String buildId;

        public void setProductName(String productName) {
            this.productName = productName;
        }

        @ApiModelProperty(value="The name of the product")
        public String getProductName() {
            return this.productName;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @ApiModelProperty(value="The qualified version")
        public String getVersion() {
            return this.version;
        }

        public void setVersionUnqualified(String versionUnqualified) {
            this.versionUnqualified = versionUnqualified;
        }

        @ApiModelProperty(value="The unqualified version")
        public String getVersionUnqualified() {
            return this.versionUnqualified;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @ApiModelProperty(value="The user agent string")
        public String getUserAgent() {
            return this.userAgent;
        }

        public void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        @ApiModelProperty(value="The build id")
        public String getBuildId() {
            return this.buildId;
        }
    }
}

