/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.aspect.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.deb.ChannelConfiguration;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.DebianAspectInformation;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.DistributionInformation;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.internal.ControlInformation;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.internal.RepoBuilder;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.aspect.aggregate.ChannelAggregator;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class AptAggregator
implements ChannelAggregator {
    private final BundleContext context = FrameworkUtil.getBundle(AptAggregator.class).getBundleContext();

    public Map<String, String> aggregateMetaData(AggregationContext context) throws Exception {
        SigningService signingService;
        HashMap<String, String> result = new HashMap<String, String>();
        Map md = context.getChannelMetaData();
        ChannelConfiguration cfg = (ChannelConfiguration)MetaKeys.bind((Object)new ChannelConfiguration(), (Map)md);
        if (!cfg.isValid()) {
            return null;
        }
        Gson gson = new GsonBuilder().create();
        ServiceReference serviceRef = null;
        if (cfg.getSigningService() != null) {
            Collection refs = this.context.getServiceReferences(SigningService.class, String.format("(%s=%s)", "service.pid", cfg.getSigningService()));
            if (refs == null || refs.isEmpty()) {
                throw new IllegalStateException(String.format("Signing service %s could not be found", cfg.getSigningService()));
            }
            serviceRef = (ServiceReference)refs.iterator().next();
            signingService = (SigningService)this.context.getService(serviceRef);
        } else {
            signingService = null;
        }
        try {
            RepoBuilder repo = new RepoBuilder(signingService);
            DistributionInformation info = new DistributionInformation();
            info.setArchitectures(new TreeSet<String>(cfg.getArchitectures()));
            info.setComponents(new TreeSet<String>(Collections.singleton(cfg.getDefaultComponent())));
            info.setVersion(cfg.getVersion());
            info.setDescription(cfg.getDescription());
            info.setLabel(cfg.getLabel());
            info.setSuite(cfg.getSuite());
            info.setCodename(cfg.getCodename());
            info.setOrigin(cfg.getOrigin());
            repo.addDistribution(cfg.getDistribution(), info);
            for (ArtifactInformation art : context.getArtifacts()) {
                String arch = (String)art.getMetaData().get(DebianAspectInformation.KEY_ARCH);
                String packageName = (String)art.getMetaData().get(DebianAspectInformation.KEY_PACKAGE);
                String version = (String)art.getMetaData().get(DebianAspectInformation.KEY_VERSION);
                String controlJson = (String)art.getMetaData().get(DebianAspectInformation.KEY_CONTROL_JSON);
                String md5 = (String)art.getMetaData().get(new MetaKey("hasher", "md5"));
                String sha1 = (String)art.getMetaData().get(new MetaKey("hasher", "sha1"));
                String sha256 = (String)art.getMetaData().get(new MetaKey("hasher", "sha256"));
                HashMap<String, String> checksums = new HashMap<String, String>(3);
                checksums.put("MD5sum", md5);
                checksums.put("SHA1", sha1);
                checksums.put("SHA256", sha256);
                if (arch == null || version == null || packageName == null || controlJson == null) continue;
                ControlInformation control = (ControlInformation)gson.fromJson(controlJson, ControlInformation.class);
                RepoBuilder.PackageInformation packageInfo = new RepoBuilder.PackageInformation(this.makePoolName(art, packageName, version, arch), art.getSize(), control.getValues(), checksums);
                repo.addPackage(cfg.getDistribution(), cfg.getDefaultComponent(), arch, packageInfo, (severity, msg) -> context.validationMessage(severity, msg, Collections.singleton(art.getId())));
            }
            repo.spoolOut((name, mimeType, stream) -> context.createCacheEntry(name, name, mimeType, stream));
        }
        catch (Throwable throwable) {
            if (serviceRef != null) {
                this.context.ungetService(serviceRef);
            }
            throw throwable;
        }
        if (serviceRef != null) {
            this.context.ungetService(serviceRef);
        }
        return result;
    }

    private String makePoolName(ArtifactInformation art, String packageName, String version, String arch) {
        return String.format("pool/%s/%s_%s_%s.deb", art.getId(), packageName, version, arch);
    }
}

