/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.ConversionException;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.Stringify;

public class StringifyConverter
implements Converter {
    public static final StringifyConverter INSTANCE = new StringifyConverter();

    private StringifyConverter() {
    }

    @Override
    public Object convertTo(Object value, Class<?> clazz, ConversionContext context) throws ConversionException {
        if (value instanceof String) {
            return this.fromString((String)value, clazz);
        }
        if (clazz.equals(String.class)) {
            return value.toString();
        }
        throw new ConversionException("Illegal combination for StringifyConverter");
    }

    private Object fromString(String value, Class<?> clazz) throws ConversionException {
        try {
            Method m = clazz.getDeclaredMethod("valueOf", String.class);
            return clazz.cast(m.invoke(null, value));
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        return this.canConvert(from, to, null);
    }

    @Override
    public boolean canConvert(Class<?> from, Class<?> to, AnnotatedElement annotatedElement) {
        if (!from.equals(String.class) && !to.equals(String.class)) {
            return false;
        }
        if (annotatedElement != null && annotatedElement.isAnnotationPresent(Stringify.class)) {
            return true;
        }
        return to.isAnnotationPresent(Stringify.class);
    }
}

