/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactory;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryInformation;
import org.eclipse.packagedrone.utils.Holder;
import org.eclipse.packagedrone.utils.osgi.FactoryTracker;
import org.eclipse.packagedrone.utils.osgi.SimpleFactoryTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProcessorFactoryTracker {
    public static final String PROP_ID = "drone.trigger.processor.factory.id";
    private final SimpleFactoryTracker<ProcessorFactory, ProcessorFactoryInformationExt> tracker;

    public ProcessorFactoryTracker(BundleContext context) {
        this.tracker = new SimpleFactoryTracker(context, ProcessorFactory.class, ref -> FactoryTracker.getString((ServiceReference)ref, (String)PROP_ID), (ref, service) -> new ProcessorFactoryInformationExt(FactoryTracker.getString((ServiceReference)ref, (String)PROP_ID), (ProcessorFactory)service));
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public void process(String factoryId, Consumer<ProcessorFactory> factory) {
        this.tracker.consume(factoryId, entry -> factory.accept(entry.getFactory()));
    }

    public void processOptionally(String factoryId, Consumer<Optional<ProcessorFactory>> factory) {
        this.tracker.consumeOptionally(factoryId, entry -> factory.accept(entry.map(ProcessorFactoryInformationExt::getFactory)));
    }

    public List<ProcessorFactoryInformation> getFactoriesFor(Class<?>[] contextClasses) {
        Objects.requireNonNull(contextClasses);
        ArrayList<ProcessorFactoryInformation> result = new ArrayList<ProcessorFactoryInformation>();
        this.tracker.consumeAll(stream -> stream.filter(service -> this.isMatch((ProcessorFactoryInformationExt)service, contextClasses)).forEach(result::add));
        return result;
    }

    public Optional<ProcessorFactoryInformation> getFactoryInformation(String factoryId) {
        Holder result = new Holder(Optional.empty());
        this.tracker.consumeOptionally(factoryId, factory -> {
            Optional<ProcessorFactoryInformation> optional = holder.value = Optional.ofNullable(factory.orElse(null));
        });
        return (Optional)result.value;
    }

    private boolean isMatch(ProcessorFactoryInformationExt service, Class<?>[] contextClasses) {
        if (service == null || contextClasses == null || contextClasses.length <= 0) {
            return false;
        }
        ProcessorFactory factory = service.getFactory();
        Class<?>[] classArray = contextClasses;
        int n = contextClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> contextClass = classArray[n2];
            if (contextClass != null && factory.supportsContext(contextClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class ProcessorFactoryInformationExt
    extends ProcessorFactoryInformation {
        private final ProcessorFactory factory;

        public ProcessorFactoryInformationExt(String id, ProcessorFactory factory) {
            super(id, factory.getLabel(), factory.getDescription(), factory.getConfigurationUrl());
            this.factory = factory;
        }

        public ProcessorFactory getFactory() {
            return this.factory;
        }
    }
}

