/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.utils.security.pgp.SigningStream;

public abstract class AbstractSecretKeySigningService
implements SigningService {
    private static final byte[] NL_DATA = "\n".getBytes(StandardCharsets.UTF_8);
    private final PGPSecretKey secretKey;
    private final PGPPrivateKey privateKey;

    public AbstractSecretKeySigningService(PGPSecretKey secretKey, String passphrase) throws PGPException {
        this.secretKey = secretKey;
        this.privateKey = this.secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
    }

    public void printPublicKey(OutputStream out) throws IOException {
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(out);
        armoredOutput.setHeader("Version", VersionInformation.VERSIONED_PRODUCT);
        PGPPublicKey pubKey = this.secretKey.getPublicKey();
        pubKey.encode((OutputStream)new BCPGOutputStream((OutputStream)armoredOutput));
        armoredOutput.close();
    }

    public OutputStream signingStream(OutputStream stream, boolean inline) {
        return new SigningStream(stream, this.privateKey, 2, inline, VersionInformation.VERSIONED_PRODUCT);
    }

    public void sign(InputStream in, OutputStream out, boolean inline) throws Exception {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(this.privateKey.getPublicKeyPacket().getAlgorithm(), 2));
        if (inline) {
            signatureGenerator.init(1, this.privateKey);
        } else {
            signatureGenerator.init(0, this.privateKey);
        }
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(out);
        armoredOutput.setHeader("Version", VersionInformation.VERSIONED_PRODUCT);
        if (inline) {
            String line;
            armoredOutput.beginClearText(2);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = lnr.readLine()) != null) {
                if (lnr.getLineNumber() > 1) {
                    signatureGenerator.update(NL_DATA);
                }
                byte[] data = AbstractSecretKeySigningService.trimTrailing(line).getBytes(StandardCharsets.UTF_8);
                if (inline) {
                    armoredOutput.write(data);
                    armoredOutput.write(NL_DATA);
                }
                signatureGenerator.update(data);
            }
            armoredOutput.endClearText();
        } else {
            int rc;
            byte[] buffer = new byte[4096];
            while ((rc = in.read(buffer)) >= 0) {
                signatureGenerator.update(buffer, 0, rc);
            }
        }
        PGPSignature signature = signatureGenerator.generate();
        signature.encode((OutputStream)new BCPGOutputStream((OutputStream)armoredOutput));
        armoredOutput.close();
    }

    private static String trimTrailing(String line) {
        char[] content = line.toCharArray();
        int idx = content.length - 1;
        block3: while (idx > 0) {
            switch (content[idx]) {
                case '\t': 
                case ' ': {
                    --idx;
                    break;
                }
                default: {
                    break block3;
                }
            }
        }
        return String.valueOf(content, 0, idx + 1);
    }
}

