/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.osgi;

import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiExtractor;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiAspectFactory
implements ChannelAspectFactory {
    private static final Logger logger = LoggerFactory.getLogger(OsgiAspectFactory.class);
    public static final String ID = "osgi";

    public ChannelAspect createAspect() {
        return new ChannelAspectImpl();
    }

    public static <T extends BundleInformation> T fetchBundleInformation(Map<MetaKey, String> metadata, Class<T> clazz) {
        String string = metadata.get(OsgiExtractor.KEY_BUNDLE_INFORMATION);
        if (string == null) {
            return null;
        }
        try {
            return (T)BundleInformation.fromJson((String)string, clazz);
        }
        catch (Exception e) {
            logger.debug("Failed to parse bundle information", (Throwable)e);
            return null;
        }
    }

    public static <T extends FeatureInformation> T fetchFeatureInformation(Map<MetaKey, String> metadata, Class<T> clazz) {
        String string = metadata.get(OsgiExtractor.KEY_FEATURE_INFORMATION);
        if (string == null) {
            return null;
        }
        try {
            return (T)FeatureInformation.fromJson((String)string, clazz);
        }
        catch (Exception e) {
            logger.debug("Failed to parse feature information", (Throwable)e);
            return null;
        }
    }

    public static BundleInformation fetchBundleInformation(Map<MetaKey, String> metadata) {
        return OsgiAspectFactory.fetchBundleInformation(metadata, BundleInformation.class);
    }

    public static FeatureInformation fetchFeatureInformation(Map<MetaKey, String> metadata) {
        return OsgiAspectFactory.fetchFeatureInformation(metadata, FeatureInformation.class);
    }

    private static class ChannelAspectImpl
    implements ChannelAspect {
        private ChannelAspectImpl() {
        }

        public Extractor getExtractor() {
            return new OsgiExtractor();
        }

        public String getId() {
            return OsgiAspectFactory.ID;
        }
    }
}

