/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.osgi;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformationParser;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformationParser;
import org.eclipse.scada.utils.ExceptionHelper;

public class OsgiExtractor
implements Extractor {
    private static final String KEY_NAME_CLASSIFIER = "classifier";
    private static final String KEY_NAME_MANIFEST = "manifest";
    private static final String KEY_NAME_FULL_MANIFEST = "fullManifest";
    private static final String KEY_NAME_VERSION = "version";
    private static final String KEY_NAME_NAME = "name";
    private static final String KEY_NAME_BUNDLE_INFORMATION = "bundle-information";
    private static final String KEY_NAME_FEATURE_INFORMATION = "feature-information";
    private static final String NAMESPACE = "osgi";
    public static final MetaKey KEY_CLASSIFIER = new MetaKey("osgi", "classifier");
    public static final MetaKey KEY_MANIFEST = new MetaKey("osgi", "manifest");
    public static final MetaKey KEY_FULL_MANIFEST = new MetaKey("osgi", "fullManifest");
    public static final MetaKey KEY_VERSION = new MetaKey("osgi", "version");
    public static final MetaKey KEY_NAME = new MetaKey("osgi", "name");
    public static final MetaKey KEY_BUNDLE_INFORMATION = new MetaKey("osgi", "bundle-information");
    public static final MetaKey KEY_FEATURE_INFORMATION = new MetaKey("osgi", "feature-information");

    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        this.extractBundleInformation(context, metadata);
        this.extractFeatureInformation(context, metadata);
    }

    private void extractFeatureInformation(Extractor.Context context, Map<String, String> metadata) throws Exception {
        FeatureInformation fi;
        block12: {
            try {
                Throwable throwable = null;
                Object var5_5 = null;
                try (ZipFile zipFile = new ZipFile(context.getPath().toFile());){
                    fi = new FeatureInformationParser(zipFile).parse();
                    if (fi != null) break block12;
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ZipException zipException) {
                return;
            }
        }
        metadata.put(KEY_NAME_NAME, fi.getId());
        metadata.put(KEY_NAME_VERSION, "" + fi.getVersion());
        metadata.put(KEY_NAME_CLASSIFIER, "eclipse.feature");
        metadata.put("artifactLabel", "Eclipse Feature");
        metadata.put(KEY_NAME_FEATURE_INFORMATION, fi.toJson());
    }

    /*
     * Unable to fully structure code
     */
    private void extractBundleInformation(Extractor.Context context, Map<String, String> metadata) throws Exception {
        try {
            var4_3 = null;
            var5_5 = null;
            try {
                zipFile = new ZipFile(context.getPath().toFile());
                try {
                    m = zipFile.getEntry("META-INF/MANIFEST.MF");
                    if (m == null) {
                        return;
                    }
                    var8_9 = null;
                    var9_11 = null;
                    try {
                        is = zipFile.getInputStream(m);
                        try {
                            data = ByteStreams.toByteArray((InputStream)is);
                            metadata.put("fullManifest", StandardCharsets.UTF_8.decode(ByteBuffer.wrap(data)).toString());
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Throwable var9_12) {
                        if (var8_9 == null) {
                            var8_9 = var9_12;
                        } else if (var8_9 != var9_12) {
                            var8_9.addSuppressed(var9_12);
                        }
                        throw var8_9;
                    }
                    var9_11 = null;
                    var10_15 = null;
                    try {
                        is = zipFile.getInputStream(m);
                        try {
                            manifest = new Manifest(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Throwable var10_16) {
                        if (var9_11 == null) {
                            var9_11 = var10_16;
                        } else if (var9_11 != var10_16) {
                            var9_11.addSuppressed(var10_16);
                        }
                        throw var9_11;
                    }
                    try {
                        bi = new BundleInformationParser(zipFile, manifest).parse();
                    }
                    catch (Exception e) {
                        context.validationError(ExceptionHelper.getMessage((Throwable)e));
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        return;
                    }
                }
                finally {
                    if (zipFile == null) ** continue;
                    zipFile.close();
                }
            }
            catch (Throwable var5_6) {
                if (var4_3 == null) {
                    var4_3 = var5_6;
                } else if (var4_3 != var5_6) {
                    var4_3.addSuppressed(var5_6);
                }
                throw var4_3;
            }
        }
        catch (ZipException v0) {
            return;
        }
    }

    private boolean validateBundle(Extractor.Context context, BundleInformation bi) {
        boolean valid = true;
        String bsn = bi.getId();
        if (bsn.contains(",")) {
            context.validationError("Bundle Symbolic Name contains a comma: " + bsn);
            valid = false;
        }
        return valid;
    }
}

