/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.generator.ArtifactGenerator;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.repo.generator.GeneratorInformation;
import org.eclipse.packagedrone.web.LinkTarget;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class GeneratorProcessor {
    private final ServiceTracker<ArtifactGenerator, ArtifactGenerator> tracker;

    public GeneratorProcessor(BundleContext context) {
        this.tracker = new ServiceTracker(context, ArtifactGenerator.class, null);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    protected Map<String, ArtifactGenerator> getAllFactories() {
        SortedMap tracked = this.tracker.getTracked();
        HashMap<String, ArtifactGenerator> result = new HashMap<String, ArtifactGenerator>(tracked.size());
        for (Map.Entry entry : tracked.entrySet()) {
            Object key = ((ServiceReference)entry.getKey()).getProperty("pm.generator.id");
            if (!(key instanceof String)) continue;
            result.put((String)key, (ArtifactGenerator)entry.getValue());
        }
        return result;
    }

    public void process(String generatorId, Consumer<ArtifactGenerator> consumer) {
        ArtifactGenerator gen = this.getAllFactories().get(generatorId);
        if (gen == null) {
            throw new IllegalStateException(String.format("Artifact generator '%s' is not registered", generatorId));
        }
        consumer.accept(gen);
    }

    public void process(String generatorId, GenerationContext context) throws Exception {
        this.process(generatorId, (ArtifactGenerator gen) -> {
            try {
                gen.generate(context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Map<String, GeneratorInformation> getInformations() {
        HashMap<String, GeneratorInformation> result = new HashMap<String, GeneratorInformation>();
        for (Map.Entry gen : this.tracker.getTracked().entrySet()) {
            String id = GeneratorProcessor.getString((ServiceReference)gen.getKey(), "pm.generator.id");
            String label = GeneratorProcessor.getString((ServiceReference)gen.getKey(), "service.pid");
            String description = GeneratorProcessor.getString((ServiceReference)gen.getKey(), "service.description");
            if (id == null) continue;
            LinkTarget addTarget = ((ArtifactGenerator)gen.getValue()).getAddTarget();
            result.put(id, new GeneratorInformation(id, label, description, addTarget));
        }
        return result;
    }

    private static String getString(ServiceReference<?> ref, String name) {
        Object v = ref.getProperty(name);
        if (v == null) {
            return null;
        }
        return v.toString();
    }
}

