/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ControllerCall;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptorProcessor;
import org.eclipse.packagedrone.web.controller.Controllers;
import org.eclipse.packagedrone.web.controller.routing.RequestMappingInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerEntry {
    private static final Logger logger = LoggerFactory.getLogger(ControllerEntry.class);
    private final Object controller;
    private final Set<ControllerCall> calls = new HashSet<ControllerCall>();
    private final ViewResolver viewResolver;

    public ControllerEntry(Object controller) {
        this.controller = controller;
        Class<?> clazz = controller.getClass();
        this.viewResolver = clazz.getAnnotation(ViewResolver.class);
        Set<ControllerInterceptorProcessor> interceptors = this.interceptorsFromController();
        logger.debug("Interceptors for {}: {}", controller, interceptors);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            RequestMappingInformation rmi = ControllerEntry.parse(clazz, m);
            if (rmi != null) {
                this.calls.add(new ControllerCall(controller, rmi, m, interceptors));
            }
            ++n2;
        }
    }

    private Set<ControllerInterceptorProcessor> interceptorsFromController() {
        ControllerInterceptor[] interceptors = (ControllerInterceptor[])this.controller.getClass().getAnnotationsByType(ControllerInterceptor.class);
        HashSet<ControllerInterceptorProcessor> result = new HashSet<ControllerInterceptorProcessor>(interceptors.length);
        ControllerInterceptor[] controllerInterceptorArray = interceptors;
        int n = interceptors.length;
        int n2 = 0;
        while (n2 < n) {
            ControllerInterceptor inter = controllerInterceptorArray[n2];
            try {
                result.add(inter.value().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return result;
    }

    public Object getController() {
        return this.controller;
    }

    public ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    protected static RequestMappingInformation parse(Class<?> controllerClazz, Method method) {
        return Controllers.fromMethod(controllerClazz, method);
    }

    public RequestHandler findHandler(HttpServletRequest request, HttpServletResponse response) {
        for (ControllerCall call : this.calls) {
            RequestHandler handler;
            RequestMappingInformation.Match match = call.matches(request);
            if (match == null || (handler = call.call(match, request, response)) == null) continue;
            return handler;
        }
        return null;
    }

    public String toString() {
        return String.format("[Controller: %s]", this.controller);
    }
}

