/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.apm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.job.ErrorInformation;
import org.eclipse.packagedrone.job.JobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.job.JobRequest;
import org.eclipse.packagedrone.job.State;
import org.eclipse.packagedrone.job.apm.FactoryManager;
import org.eclipse.packagedrone.job.apm.JobHandleImpl;
import org.eclipse.packagedrone.job.apm.JobQueue;
import org.eclipse.packagedrone.job.apm.model.JobInstanceEntity;
import org.eclipse.packagedrone.job.apm.model.JobModel;
import org.eclipse.packagedrone.job.apm.model.JobModelProvider;
import org.eclipse.packagedrone.job.apm.model.JobWriteModel;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerImpl
implements JobManager {
    private static final Logger logger = LoggerFactory.getLogger(JobManagerImpl.class);
    private static final MetaKey MODEL_KEY = new MetaKey("scheduler", "jobs");
    private StorageManager storageManager;
    private StorageRegistration handle;
    private final JobQueue queue = new JobQueue();
    private final FactoryManager factoryManager = new FactoryManager(FrameworkUtil.getBundle(JobManagerImpl.class).getBundleContext());

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void start() {
        this.factoryManager.start();
        this.queue.start();
        this.handle = this.storageManager.registerModel(10000L, MODEL_KEY, (StorageModelProvider)new JobModelProvider());
    }

    public void stop() {
        this.queue.stop();
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        this.factoryManager.stop();
    }

    public JobHandle startJob(JobRequest job) {
        logger.debug("Start job: {}", (Object)job);
        String factoryId = job.getFactoryId();
        Optional<JobFactory> factory = this.getJobFactory(factoryId);
        if (!factory.isPresent()) {
            throw new IllegalArgumentException(String.format("Job factory '%s' is unknown", factoryId));
        }
        return this.internalStartJob(factory.get(), factoryId, job.getData(), job.getProperties());
    }

    @Deprecated
    public JobHandle startJob(String factoryId, Object data) {
        logger.debug("Start job: {} - {}", (Object)factoryId, data);
        Optional<JobFactory> factory = this.getJobFactory(factoryId);
        if (!factory.isPresent()) {
            throw new IllegalArgumentException(String.format("Job factory '%s' is unknown", factoryId));
        }
        return this.internalStartJob(factory.get(), factoryId, factory.get().encodeConfiguration(data), null);
    }

    public Collection<? extends JobHandle> getActiveJobs() {
        return (Collection)this.storageManager.accessCall(MODEL_KEY, JobModel.class, jobs -> jobs.getJobs().values().stream().filter(job -> !job.isComplete()).collect(Collectors.toList()));
    }

    public JobHandle getJob(String id) {
        logger.trace("Get job: {}", (Object)id);
        return (JobHandle)this.storageManager.accessCall(MODEL_KEY, JobModel.class, jobs -> jobs.getJobs().get(id));
    }

    protected Optional<JobFactory> getJobFactory(String factoryId) {
        return this.factoryManager.getFactory(factoryId);
    }

    public JobFactoryDescriptor getFactory(String factoryId) {
        return this.getJobFactory(factoryId).map(JobFactory::getDescriptor).orElse(null);
    }

    private JobHandle internalStartJob(JobFactory factory, String factoryId, String data, Map<String, String> properties) {
        String id = JobManagerImpl.makeId();
        JobHandle handle = (JobHandle)this.storageManager.modifyCall(MODEL_KEY, JobWriteModel.class, jobs -> {
            JobInstanceEntity ji = new JobInstanceEntity();
            ji.setId(id);
            ji.setFactoryId(factoryId);
            ji.setData(data);
            ji.setState(State.SCHEDULED);
            ji.setLabel(factory.makeLabel(data));
            ji.setProperties(properties != null ? new HashMap(properties) : Collections.emptyMap());
            StorageManager.executeAfterPersist(() -> this.queue.push(new ContextImpl(id, factory, data)));
            jobs.addJob(ji);
            return new JobHandleImpl(ji);
        });
        return handle;
    }

    private static String makeId() {
        return UUID.randomUUID().toString();
    }

    protected void modifyJob(String id, Consumer<JobInstanceEntity> consumer) {
        this.storageManager.modifyRun(MODEL_KEY, JobWriteModel.class, jobs -> {
            JobInstanceEntity ji = jobs.getJobForUpdate(id);
            if (ji == null) {
                throw new IllegalStateException(String.format("Unable to find job '%s'", id));
            }
            consumer.accept(ji);
        });
    }

    protected void internalSetError(String id, Throwable e) {
        ErrorInformation error = ErrorInformation.createFrom((Throwable)e);
        logger.debug("{}: set error: {}", (Object)id, (Object)error);
        this.modifyJob(id, job -> job.setErrorInformation(error));
    }

    public void internalSetResult(String id, String data) {
        logger.trace("{}: set result: {}", (Object)id, (Object)data);
        this.modifyJob(id, job -> job.setResult(data));
    }

    public void internalSetRunning(String id) {
        logger.debug("{}: set running", (Object)id);
        this.modifyJob(id, job -> job.setState(State.RUNNING));
    }

    public void internalSetComplete(String id) {
        logger.debug("{}: set complete", (Object)id);
        this.modifyJob(id, job -> job.setState(State.COMPLETE));
    }

    public void internalWorked(String id, double percentComplete) {
        logger.trace("{}: worked: {}", (Object)id, (Object)percentComplete);
        this.modifyJob(id, job -> job.setPercentComplete(percentComplete));
    }

    public void internalStartWork(String id, String label) {
        logger.trace("{}: set start work: {}", (Object)id, (Object)label);
        this.modifyJob(id, job -> {
            job.setCurrentWorkLabel(label);
            job.setPercentComplete(0.0);
        });
    }

    public void internalSetTaskLabel(String id, String label) {
        logger.trace("{}: set task label: {}", (Object)id, (Object)label);
        this.modifyJob(id, job -> job.setCurrentWorkLabel(label));
    }

    public class ContextImpl
    implements JobInstance.Context,
    Runnable {
        private final String id;
        private long totalAmount;
        private long worked;
        private String label;
        private final JobFactory factory;
        private final String data;

        public ContextImpl(String id, JobFactory factory, String data) {
            this.id = id;
            this.factory = factory;
            this.data = data;
        }

        @Override
        public void run() {
            try {
                try {
                    JobInstance instance = this.factory.createInstance(this.data);
                    JobManagerImpl.this.internalSetRunning(this.id);
                    instance.run((JobInstance.Context)this);
                }
                catch (Throwable e) {
                    logger.debug("Failed to run job", e);
                    JobManagerImpl.this.internalSetError(this.id, e);
                    JobManagerImpl.this.internalSetComplete(this.id);
                }
            }
            finally {
                JobManagerImpl.this.internalSetComplete(this.id);
            }
        }

        public void beginWork(String label, long amount) {
            this.totalAmount = amount;
            this.label = label;
            JobManagerImpl.this.internalStartWork(this.id, label);
        }

        public void setCurrentTaskName(String name) {
            JobManagerImpl.this.internalSetTaskLabel(this.id, name == null ? this.label : String.format("%s: %s", this.label, name));
        }

        public void complete() {
            JobManagerImpl.this.internalWorked(this.id, 1.0);
        }

        public void worked(long amount) {
            this.worked = Math.min(this.worked + amount, this.totalAmount);
            JobManagerImpl.this.internalWorked(this.id, (double)this.worked / (double)this.totalAmount);
        }

        public void setResult(String data) {
            logger.debug("Setting result for job {}: {}", (Object)this.id, (Object)data);
            JobManagerImpl.this.internalSetResult(this.id, data);
        }
    }
}

