/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.sitemap.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.web.sitemap.servlet.SitemapProcessor;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;

public class SitemapServlet
extends HttpServlet {
    private static final String SITEMAP_XML = "/sitemap.xml";
    private static final long serialVersionUID = 1L;
    private XmlToolsFactory xml;
    private SitePrefixService prefixService;
    private SitemapProcessor processor;

    public void setXml(XmlToolsFactory xml) {
        this.xml = xml;
    }

    public void setPrefixService(SitePrefixService prefixService) {
        this.prefixService = prefixService;
    }

    public void init() throws ServletException {
        super.init();
        this.processor = new SitemapProcessor(() -> ((SitePrefixService)this.prefixService).getSitePrefix(), SITEMAP_XML, this.xml.newXMLOutputFactory());
    }

    public void destroy() {
        super.destroy();
        this.processor.dispose();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getRequestURI();
        if (path == null || !path.startsWith(SITEMAP_XML)) {
            this.handleNotFound(req, resp);
        } else {
            String subPath = path.substring(SITEMAP_XML.length());
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            if (!this.processor.process(resp, subPath)) {
                this.handleNotFound(req, resp);
            }
        }
    }

    private void handleNotFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(404);
        response.setContentType("text/plain");
        response.getWriter().format("Resource '%s' could not be found", request.getRequestURI());
    }
}

