/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CheckedInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.CRC32;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.check.SHA256;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.index.IndexBase;

public class IndexHash
extends IndexBase {
    private Check hash;

    public IndexHash() {
        super(new CorruptedInputException());
        try {
            this.hash = new SHA256();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.hash = new CRC32();
        }
    }

    @Override
    public void add(long unpaddedSize, long uncompressedSize) throws XZIOException {
        super.add(unpaddedSize, uncompressedSize);
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(unpaddedSize);
        buf.putLong(uncompressedSize);
        this.hash.update(buf.array());
    }

    public void validate(InputStream in) throws IOException {
        java.util.zip.CRC32 crc32 = new java.util.zip.CRC32();
        crc32.update(0);
        CheckedInputStream inChecked = new CheckedInputStream(in, crc32);
        long storedRecordCount = DecoderUtil.decodeVLI(inChecked);
        if (storedRecordCount != this.recordCount) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        IndexHash stored = new IndexHash();
        long i = 0L;
        while (i < this.recordCount) {
            long unpaddedSize = DecoderUtil.decodeVLI(inChecked);
            long uncompressedSize = DecoderUtil.decodeVLI(inChecked);
            try {
                stored.add(unpaddedSize, uncompressedSize);
            }
            catch (XZIOException xZIOException) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (stored.blocksSum > this.blocksSum || stored.uncompressedSum > this.uncompressedSum || stored.indexListSize > this.indexListSize) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            ++i;
        }
        if (stored.blocksSum != this.blocksSum || stored.uncompressedSum != this.uncompressedSum || stored.indexListSize != this.indexListSize || !Arrays.equals(stored.hash.finish(), this.hash.finish())) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        DataInputStream inData = new DataInputStream(inChecked);
        int i2 = this.getIndexPaddingSize();
        while (i2 > 0) {
            if (inData.readUnsignedByte() != 0) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            --i2;
        }
        long value = crc32.getValue();
        int i3 = 0;
        while (i3 < 4) {
            if ((value >>> i3 * 8 & 0xFFL) != (long)inData.readUnsignedByte()) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            ++i3;
        }
    }
}

