/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ScheduledExecutorPingSender
implements MqttPingSender {
    private static final String CLASS_NAME = ScheduledExecutorPingSender.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private ClientComms comms;
    private ScheduledExecutorService executorService;
    private ScheduledFuture scheduledFuture;
    private String clientid;

    public ScheduledExecutorPingSender(ScheduledExecutorService executorService) {
        if (executorService == null) {
            throw new IllegalArgumentException("ExecutorService cannot be null.");
        }
        this.executorService = executorService;
    }

    @Override
    public void init(ClientComms comms) {
        if (comms == null) {
            throw new IllegalArgumentException("ClientComms cannot be null.");
        }
        this.comms = comms;
        this.clientid = comms.getClient().getClientId();
    }

    @Override
    public void start() {
        String methodName = "start";
        this.log.fine(CLASS_NAME, "start", "659", new Object[]{this.clientid});
        this.schedule(this.comms.getKeepAlive());
    }

    @Override
    public void stop() {
        String methodName = "stop";
        this.log.fine(CLASS_NAME, "stop", "661", null);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public void schedule(long delayInMilliseconds) {
        this.scheduledFuture = this.executorService.schedule(new PingRunnable(), delayInMilliseconds, TimeUnit.MILLISECONDS);
    }

    private class PingRunnable
    implements Runnable {
        private static final String methodName = "PingTask.run";

        private PingRunnable() {
        }

        @Override
        public void run() {
            String originalThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("MQTT Ping: " + ScheduledExecutorPingSender.this.clientid);
            ScheduledExecutorPingSender.this.log.fine(CLASS_NAME, methodName, "660", new Object[]{System.nanoTime()});
            ScheduledExecutorPingSender.this.comms.checkForActivity();
            Thread.currentThread().setName(originalThreadName);
        }
    }
}

