/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.server.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.server.tcp.SessionManager;

public class EclTcpServer
extends Thread {
    private final ServerSocket socket;
    private final int port;
    private volatile boolean starting = true;
    private SessionManager manager = null;

    public boolean isStarting() {
        return this.starting;
    }

    public EclTcpServer(int port, boolean useJobs) throws IOException {
        super("ECL TCP server: " + port + " main");
        this.socket = new ServerSocket(port);
        this.port = port;
        this.manager = new SessionManager(useJobs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.starting = false;
        try {
            while (true) {
                if (this.isInterrupted()) {
                    if (this.socket == null) return;
                    this.socket.close();
                    return;
                }
                try {
                    Socket client = this.socket.accept();
                    client.setTcpNoDelay(true);
                    this.manager.acceptNewConnection(client);
                }
                catch (Exception e) {
                    CorePlugin.log((IStatus)CorePlugin.err((String)"Failed to accept connection", (Throwable)e));
                }
            }
        }
        catch (Exception e) {
            CorePlugin.log((IStatus)CorePlugin.err((String)"Failed to start ECL TCP server", (Throwable)e));
        }
    }

    public int getPort() {
        return this.port;
    }
}

