/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import org.eclipse.jdt.internal.ui.macbundler.BundleAttributes;
import org.eclipse.jdt.internal.ui.macbundler.BundleDescription;
import org.eclipse.jdt.internal.ui.macbundler.Util;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class BundleWizardBasePage
extends DialogPage
implements IWizardPage,
BundleAttributes,
IPropertyChangeListener {
    private IWizardPage fPreviousPage;
    private String fKey;
    private IWizard fWizard;
    BundleDescription fBundleDescription;

    BundleWizardBasePage(String key, BundleDescription bd) {
        super(Util.getString(String.valueOf(key) + ".title"));
        this.fKey = key;
        this.fBundleDescription = bd;
        this.setDescription(Util.getString(String.valueOf(this.fKey) + ".description"));
        bd.addListener(this);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.enterPage();
        } else {
            this.leavePage();
        }
        super.setVisible(visible);
    }

    void enterPage() {
    }

    void leavePage() {
    }

    public Image getImage() {
        Image result = super.getImage();
        if (result == null && this.fWizard != null) {
            return this.fWizard.getDefaultPageImage();
        }
        return result;
    }

    public final void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)c);
        this.createContents(c);
        this.checkIfPageComplete();
    }

    public abstract void createContents(Composite var1);

    static void setHeightHint(Control control, int height) {
        GridData gd1 = new GridData(770);
        gd1.heightHint = height;
        control.setLayoutData((Object)gd1);
    }

    static Label createLabel(Composite parent, String text, int align) {
        Label l = new Label(parent, 0);
        l.setText(text);
        l.setLayoutData((Object)new GridData(align));
        return l;
    }

    static Composite createComposite(Composite parent, int columns) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        return c;
    }

    Text createText(Composite parent, String key, int lines) {
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        if (lines == 2) {
            gd.heightHint = 30;
        }
        t.setLayoutData((Object)gd);
        this.hookField(t, key);
        return t;
    }

    Combo createCombo(Composite parent, String key) {
        Combo c = new Combo(parent, 2048);
        c.setLayoutData((Object)new GridData(768));
        this.hookField(c, key);
        return c;
    }

    static Group createGroup(Composite parent, String text, int columns) {
        Group g = new Group(parent, 0);
        g.setText(text);
        g.setLayoutData((Object)new GridData(768));
        g.setLayout((Layout)new GridLayout(columns, false));
        return g;
    }

    Button createButton(Composite parent, int flags, String text) {
        Button b = new Button(parent, flags);
        if (text != null) {
            b.setText(text);
        }
        return b;
    }

    static Composite createHBox(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        return c;
    }

    void hookField(final Text tf, final String key) {
        tf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleWizardBasePage.this.fBundleDescription.setValue(key, tf.getText());
                BundleWizardBasePage.this.checkIfPageComplete();
            }
        });
    }

    void hookField(final Combo tf, final String key) {
        tf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BundleWizardBasePage.this.fBundleDescription.setValue(key, tf.getText());
                BundleWizardBasePage.this.checkIfPageComplete();
            }
        });
    }

    void hookButton(final Button b, final String key) {
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleWizardBasePage.this.fBundleDescription.setValue(key, new Boolean(b.getSelection()));
                BundleWizardBasePage.this.checkIfPageComplete();
            }
        });
    }

    final void checkIfPageComplete() {
        IWizardContainer c;
        IWizardContainer iWizardContainer = c = this.fWizard != null ? this.fWizard.getContainer() : null;
        if (c != null && this == c.getCurrentPage()) {
            c.updateButtons();
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() != null;
    }

    public String getName() {
        return Util.getString(String.valueOf(this.fKey) + ".title");
    }

    public IWizardPage getNextPage() {
        if (this.fWizard == null) {
            return null;
        }
        return this.fWizard.getNextPage((IWizardPage)this);
    }

    public IWizardPage getPreviousPage() {
        if (this.fPreviousPage != null) {
            return this.fPreviousPage;
        }
        if (this.fWizard != null) {
            return this.fWizard.getPreviousPage((IWizardPage)this);
        }
        return null;
    }

    public IWizard getWizard() {
        return this.fWizard;
    }

    public void setPreviousPage(IWizardPage page) {
        this.fPreviousPage = page;
    }

    public void setWizard(IWizard newWizard) {
        this.fWizard = newWizard;
    }
}

