/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class LanguageInFilter
extends FilterPlanNode {
    private final List<String> languageIn;

    public LanguageInFilter(PlanNode parent, List<String> languageIn) {
        super(parent);
        this.languageIn = languageIn;
    }

    @Override
    boolean checkTuple(Tuple t) {
        if (!(t.line.get(1) instanceof Literal)) {
            return false;
        }
        Optional<String> language = ((Literal)t.line.get(1)).getLanguage();
        return language.filter(this.languageIn::contains).isPresent();
    }

    @Override
    public String toString() {
        return "LanguageInFilter{languageIn=" + Arrays.toString(this.languageIn.toArray()) + '}';
    }
}

