/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqljson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.sparqljson.AbstractSPARQLJSONParser;

public class SPARQLResultsJSONParser
extends AbstractSPARQLJSONParser
implements TupleQueryResultParser {
    public SPARQLResultsJSONParser() {
    }

    public SPARQLResultsJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public QueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    @Override
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.JSON;
    }

    @Override
    @Deprecated
    public void setTupleQueryResultHandler(TupleQueryResultHandler handler) {
        this.setQueryResultHandler(handler);
    }

    @Override
    @Deprecated
    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        try {
            this.parseQueryResultInternal(in, false, true);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    protected Triple parseTripleValue(JsonParser jp, String fieldName) throws IOException {
        Value subject = null;
        Value predicate = null;
        Value object = null;
        while (subject == null || predicate == null || object == null) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new QueryResultParseException("Did not find triple attribute in triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            String posName = jp.getCurrentName();
            if ("s".equals(posName) || "subject".equals(posName)) {
                if (subject != null) {
                    throw new QueryResultParseException(posName + " field encountered twice in triple value: ", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                subject = this.parseValue(jp, fieldName + ":" + posName);
                if (predicate != null && object != null) continue;
                jp.nextToken();
                continue;
            }
            if ("p".equals(posName) || "predicate".equals(posName)) {
                if (predicate != null) {
                    throw new QueryResultParseException(posName + " field encountered twice in triple value: ", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                predicate = this.parseValue(jp, fieldName + ":" + posName);
                if (subject != null && object != null) continue;
                jp.nextToken();
                continue;
            }
            if ("o".equals(posName) || "object".equals(posName)) {
                if (object != null) {
                    throw new QueryResultParseException(posName + " field encountered twice in triple value: ", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                }
                object = this.parseValue(jp, fieldName + ":" + posName);
                if (predicate != null && subject != null) continue;
                jp.nextToken();
                continue;
            }
            throw new QueryResultParseException("Unexpected field name in triple value: " + posName, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        if (subject instanceof Resource && predicate instanceof IRI && object != null) {
            return this.valueFactory.createTriple((Resource)subject, (IRI)predicate, object);
        }
        throw new QueryResultParseException("Incomplete or invalid triple value", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
    }

    @Override
    protected boolean checkTripleType(JsonParser jp, String type) {
        if (!"triple".equals(type) && !"statement".equals(type)) {
            throw new QueryResultParseException("Found a triple value but unexpected type: " + type, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
        }
        return true;
    }
}

