/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.inferencer.fc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;

public abstract class AbstractForwardChainingInferencer
extends NotifyingSailWrapper {
    private static final IsolationLevels READ_COMMITTED = IsolationLevels.READ_COMMITTED;

    public AbstractForwardChainingInferencer() {
    }

    public AbstractForwardChainingInferencer(NotifyingSail baseSail) {
        super(baseSail);
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        IsolationLevel level = super.getDefaultIsolationLevel();
        if (level.isCompatibleWith(READ_COMMITTED)) {
            return level;
        }
        List<IsolationLevel> supported = this.getSupportedIsolationLevels();
        return IsolationLevels.getCompatibleIsolationLevel(READ_COMMITTED, supported);
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        List<IsolationLevel> supported = super.getSupportedIsolationLevels();
        ArrayList<IsolationLevel> levels = new ArrayList<IsolationLevel>(supported.size());
        for (IsolationLevel level : supported) {
            if (!level.isCompatibleWith(READ_COMMITTED)) continue;
            levels.add(level);
        }
        return levels;
    }
}

