/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class NotValuesIn
implements PlanNode {
    private final PlanNode parent;
    private final PlanNode notIn;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public NotValuesIn(PlanNode parent, PlanNode notIn) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
        this.notIn = notIn;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            final Set<ValidationTuple> notInValueSet;
            ValidationTuple next;
            {
                this.parentIterator = NotValuesIn.this.parent.iterator();
                this.notInValueSet = new HashSet<ValidationTuple>();
                try (CloseableIteration<? extends ValidationTuple, SailException> iterator = NotValuesIn.this.notIn.iterator();){
                    while (iterator.hasNext()) {
                        this.notInValueSet.add((ValidationTuple)iterator.next());
                    }
                }
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (this.notInValueSet.contains(temp)) continue;
                    this.next = temp;
                }
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "NotValuesIn{parent=" + this.parent + ", notIn=" + this.notIn + '}';
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
        this.notIn.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }
}

