/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStatistics;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager {
    private static final Logger log = LoggerFactory.getLogger(QueryManager.class);
    private final AtomicBigInteger nextQueryID;
    private Set<QueryInfo> runningQueries = new ConcurrentSkipListSet<QueryInfo>();
    private Map<String, String> prefixDeclarations = new HashMap<String, String>();
    private FedXRepository repo;
    private FederationContext federationContext;
    private transient RepositoryConnection conn;
    static Pattern prefixCheck = Pattern.compile(".*PREFIX .*", 34);
    static Pattern prefixPattern = Pattern.compile("PREFIX[ ]*(\\w*):[ ]*<(\\S*)>", 34);

    public QueryManager() {
        BigInteger lastQueryId = new BigInteger("0");
        this.nextQueryID = new AtomicBigInteger(lastQueryId);
    }

    public void init(FedXRepository repo, FederationContext federationContext) {
        this.federationContext = federationContext;
        this.repo = repo;
        String prefixFile = federationContext.getConfig().getPrefixDeclarations();
        if (prefixFile != null) {
            Properties props = new Properties();
            try (FileInputStream fin = new FileInputStream(new File(prefixFile));){
                props.load(fin);
            }
            catch (IOException e) {
                throw new FedXRuntimeException("Error loading prefix properties: " + e.getMessage());
            }
            for (String ns : props.stringPropertyNames()) {
                this.addPrefixDeclaration(ns, props.getProperty(ns));
            }
        }
    }

    private synchronized RepositoryConnection getOrCreateConn() {
        if (this.conn == null) {
            this.conn = this.repo.getConnection();
        }
        return this.conn;
    }

    public void shutdown() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (RepositoryException e) {
                throw new FedXRuntimeException(e);
            }
        }
    }

    public void registerQuery(QueryInfo queryInfo) {
        assert (this.runningQueries.contains(queryInfo)) : "Duplicate query: query " + queryInfo.getQueryID() + " is already registered.";
        this.runningQueries.add(queryInfo);
    }

    public Set<QueryInfo> getRunningQueries() {
        return new HashSet<QueryInfo>(this.runningQueries);
    }

    public int getNumberOfRunningQueries() {
        return this.runningQueries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortQuery(QueryInfo queryInfo) {
        QueryInfo queryInfo2 = queryInfo;
        synchronized (queryInfo2) {
            if (!this.runningQueries.contains(queryInfo)) {
                return;
            }
            log.info("Aborting query " + queryInfo.getQueryID());
            queryInfo.abort();
            this.runningQueries.remove(queryInfo);
        }
    }

    public void finishQuery(QueryInfo queryInfo) {
        this.runningQueries.remove(queryInfo);
    }

    public boolean isRunning(QueryInfo queryInfo) {
        return this.runningQueries.contains(queryInfo);
    }

    public void addPrefixDeclaration(String prefix, String namespace) {
        if (namespace == null) {
            this.prefixDeclarations.remove(prefix);
            return;
        }
        this.prefixDeclarations.put(prefix, namespace);
    }

    public TupleQuery prepareTupleQuery(String queryString) throws MalformedQueryException {
        Query q = this.prepareQuery(queryString);
        if (!(q instanceof TupleQuery)) {
            throw new FedXRuntimeException("Query is not a tuple query: " + q.getClass());
        }
        return (TupleQuery)q;
    }

    public GraphQuery prepareGraphQuery(String queryString) throws MalformedQueryException {
        Query q = this.prepareQuery(queryString);
        if (!(q instanceof GraphQuery)) {
            throw new FedXRuntimeException("Query is not a graph query: " + q.getClass());
        }
        return (GraphQuery)q;
    }

    public BooleanQuery prepareBooleanQuery(String queryString) throws MalformedQueryException {
        Query q = this.prepareQuery(queryString);
        if (!(q instanceof BooleanQuery)) {
            throw new FedXRuntimeException("Unexpected query type: " + q.getClass());
        }
        return (BooleanQuery)q;
    }

    public Query prepareQuery(String queryString) throws MalformedQueryException {
        Query q;
        if (this.prefixDeclarations.size() > 0) {
            queryString = prefixCheck.matcher(queryString).matches() ? this.getPrefixDeclarationsCheck(queryString) + queryString : this.getPrefixDeclarations() + queryString;
        }
        try {
            q = this.getOrCreateConn().prepareQuery(QueryLanguage.SPARQL, queryString);
        }
        catch (RepositoryException e) {
            throw new FedXRuntimeException(e);
        }
        return q;
    }

    public String getQueryPlan(String queryString) throws MalformedQueryException, FedXException {
        ParsedOperation query;
        if (this.prefixDeclarations.size() > 0) {
            queryString = prefixCheck.matcher(queryString).matches() ? this.getPrefixDeclarationsCheck(queryString) + queryString : this.getPrefixDeclarations() + queryString;
        }
        if (!((query = QueryParserUtil.parseOperation(QueryLanguage.SPARQL, queryString, null)) instanceof ParsedQuery)) {
            throw new MalformedQueryException("Not a ParsedQuery: " + query.getClass());
        }
        QueryInfo qInfo = new QueryInfo(queryString, QueryType.SELECT, this.federationContext.getConfig().getIncludeInferredDefault(), this.federationContext, ((ParsedQuery)query).getDataset());
        TupleExpr tupleExpr = ((ParsedQuery)query).getTupleExpr();
        try {
            FederationEvaluationStatistics evaluationStatistics = new FederationEvaluationStatistics(qInfo, new SimpleDataset());
            tupleExpr = this.federationContext.getStrategy().optimize(tupleExpr, evaluationStatistics, EmptyBindingSet.getInstance());
            return tupleExpr.toString();
        }
        catch (SailException e) {
            throw new FedXException("Unable to retrieve query plan: " + e.getMessage());
        }
    }

    public BigInteger getNextQueryId() {
        return this.nextQueryID.incrementAndGet();
    }

    protected String getPrefixDeclarations() {
        StringBuilder sb = new StringBuilder();
        for (String namespace : this.prefixDeclarations.keySet()) {
            sb.append("PREFIX ").append(namespace).append(": <").append(this.prefixDeclarations.get(namespace)).append(">\r\n");
        }
        return sb.toString();
    }

    protected String getPrefixDeclarationsCheck(String queryString) {
        Set<String> queryPrefixes = QueryManager.findQueryPrefixes(queryString);
        StringBuilder sb = new StringBuilder();
        for (String prefix : this.prefixDeclarations.keySet()) {
            if (queryPrefixes.contains(prefix)) continue;
            sb.append("PREFIX ").append(prefix).append(": <").append(this.prefixDeclarations.get(prefix)).append(">\r\n");
        }
        return sb.toString();
    }

    protected static Set<String> findQueryPrefixes(String queryString) {
        HashSet<String> res = new HashSet<String>();
        Scanner sc = new Scanner(queryString);
        while (true) {
            if (sc.findInLine(prefixPattern) != null) {
                MatchResult m = sc.match();
                res.add(m.group(1));
                continue;
            }
            if (!sc.hasNextLine()) break;
            sc.nextLine();
        }
        sc.close();
        return res;
    }

    static class AtomicBigInteger {
        private final AtomicReference<BigInteger> valueHolder = new AtomicReference();

        public AtomicBigInteger(BigInteger bigInteger) {
            this.valueHolder.set(bigInteger);
        }

        public BigInteger incrementAndGet() {
            BigInteger next;
            BigInteger current;
            while (!this.valueHolder.compareAndSet(current = this.valueHolder.get(), next = current.add(BigInteger.ONE))) {
            }
            return next;
        }
    }
}

