/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;

public class NTriplesWriter
extends AbstractRDFWriter
implements RDFWriter,
CharSink {
    protected final Writer writer;
    private boolean xsdStringToPlainLiteral = true;
    private boolean escapeUnicode;

    public NTriplesWriter(OutputStream out) {
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public NTriplesWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.xsdStringToPlainLiteral = (Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        this.escapeUnicode = (Boolean)this.getWriterConfig().get(NTriplesWriterSettings.ESCAPE_UNICODE);
    }

    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String name) {
        this.checkWritingStarted();
    }

    protected void consumeStatement(Statement st) {
        try {
            this.writeValue((Value)st.getSubject());
            this.writer.write(" ");
            this.writeIRI(st.getPredicate());
            this.writer.write(" ");
            this.writeValue(st.getObject());
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.writer.write("# ");
            this.writer.write(comment);
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        result.add(NTriplesWriterSettings.ESCAPE_UNICODE);
        return result;
    }

    protected void writeValue(Value value) throws IOException {
        if (value instanceof IRI) {
            this.writeIRI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else {
            throw new IllegalArgumentException("Unknown value type: " + value.getClass());
        }
    }

    private void writeIRI(IRI iri) throws IOException {
        NTriplesUtil.append((IRI)iri, (Appendable)this.writer, (boolean)this.escapeUnicode);
    }

    private void writeBNode(BNode bNode) throws IOException {
        String nextId = bNode.getID();
        this.writer.append("_:");
        if (nextId.isEmpty()) {
            this.writer.append("genid");
            this.writer.append(Integer.toHexString(bNode.hashCode()));
        } else {
            if (!ASCIIUtil.isLetter((int)nextId.charAt(0))) {
                this.writer.append("genid");
                this.writer.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (ASCIIUtil.isLetterOrNumber((int)nextId.charAt(i))) {
                    this.writer.append(nextId.charAt(i));
                    continue;
                }
                this.writer.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
    }

    private void writeLiteral(Literal lit) throws IOException {
        NTriplesUtil.append((Literal)lit, (Appendable)this.writer, (boolean)((Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL)), (boolean)this.escapeUnicode);
    }
}

