/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text.tsv;

import com.opencsv.CSVReader;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.MappingStrategy;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractTupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.text.tsv.SPARQLResultsTSVMappingStrategy;
import org.eclipse.rdf4j.query.resultio.text.tsv.SPARQLResultsTSVReader;

public class SPARQLResultsTSVParser
extends AbstractTupleQueryResultParser
implements TupleQueryResultParser {
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    public void parse(InputStream in) throws QueryResultParseException, TupleQueryResultHandlerException {
        if (this.handler != null) {
            SPARQLResultsTSVMappingStrategy strategy = this.createMappingStrategy();
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
            CsvToBean csvToBean = new CsvToBeanBuilder((Reader)reader).withType(BindingSet.class).withMappingStrategy((MappingStrategy)strategy).withSeparator('\t').build();
            csvToBean.setCsvReader((CSVReader)new SPARQLResultsTSVReader(reader));
            List bindingSets = csvToBean.parse();
            List<String> bindingNames = strategy.getBindingNames();
            this.handler.startQueryResult(bindingNames);
            for (BindingSet bs : bindingSets) {
                this.handler.handleSolution(bs);
            }
            this.handler.endQueryResult();
        }
    }

    protected SPARQLResultsTSVMappingStrategy createMappingStrategy() {
        return new SPARQLResultsTSVMappingStrategy(this.valueFactory);
    }
}

