/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(Select.class);
    private final SailConnection connection;
    private final Function<BindingSet, ValidationTuple> mapper;
    private final String query;
    private final boolean sorted;
    private final Dataset dataset;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Select(SailConnection connection, String queryFregment, String orderBy, Function<BindingSet, ValidationTuple> mapper, Resource[] dataGraph) {
        this.connection = connection;
        this.mapper = mapper;
        if (queryFregment.trim().equals("")) {
            logger.error("Query is empty", new Throwable("This throwable is just to log the stack trace"));
            queryFregment = "?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c. \nFILTER (NOT EXISTS {?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c}) \n";
        }
        boolean bl = this.sorted = orderBy != null;
        this.query = !this.sorted && queryFregment.trim().startsWith("select ") ? queryFregment : "select * where {\n" + queryFregment + "\n} " + (String)(this.sorted ? "order by " + orderBy : "");
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
    }

    public Select(SailConnection connection, String query, Function<BindingSet, ValidationTuple> mapper, Resource[] dataGraph) {
        assert (!query.toLowerCase().contains("order by")) : "Queries with order by are not supported.";
        assert (query.trim().toLowerCase().startsWith("select")) : "Expected query to start with select.";
        this.connection = connection;
        this.mapper = mapper;
        this.query = query;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        this.sorted = false;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            {
                this.bindingSet = null;
            }

            private void init() {
                if (this.bindingSet != null) {
                    return;
                }
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                try {
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(Select.this.query, null);
                    this.bindingSet = Select.this.connection.evaluate(parsedQuery.getTupleExpr(), Select.this.dataset, EmptyBindingSet.getInstance(), true);
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query: \n{}", (Object)Select.this.query);
                    throw e;
                }
            }

            @Override
            public void localClose() throws SailException {
                if (this.bindingSet != null) {
                    this.bindingSet.close();
                }
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.init();
                return this.bindingSet.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.init();
                return Select.this.mapper.apply((BindingSet)this.bindingSet.next());
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    public String toString() {
        return "Select{query='" + this.query.replace("\n", "  ") + "'}";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return this.sorted;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        if (this.connection instanceof MemoryStoreConnection && select.connection instanceof MemoryStoreConnection) {
            return this.sorted == select.sorted && ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)select.connection).getSail()) && this.mapper.equals(select.mapper) && this.dataset.equals(select.dataset) && this.query.equals(select.query);
        }
        return this.sorted == select.sorted && this.connection.equals(select.connection) && this.mapper.equals(select.mapper) && this.dataset.equals(select.dataset) && this.query.equals(select.query);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(((MemoryStoreConnection)this.connection).getSail(), this.mapper, this.query, this.sorted, this.dataset);
        }
        return Objects.hash(this.connection, this.mapper, this.query, this.sorted, this.dataset);
    }
}

