/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.util.Collections;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.sail.memory.model.BooleanMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.CalendarMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.DecimalMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.IntegerMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.MemBNode;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.NumericMemLiteral;
import org.eclipse.rdf4j.sail.memory.model.WeakObjectRegistry;

public class MemValueFactory
extends AbstractValueFactory {
    private final WeakObjectRegistry<MemIRI> iriRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemTriple> tripleRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemBNode> bnodeRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<MemLiteral> literalRegistry = new WeakObjectRegistry();
    private final WeakObjectRegistry<String> namespaceRegistry = new WeakObjectRegistry();

    public void clear() {
        this.iriRegistry.clear();
        this.bnodeRegistry.clear();
        this.literalRegistry.clear();
        this.namespaceRegistry.clear();
    }

    public MemValue getMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getMemLiteral((Literal)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getMemResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getMemURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getMemBNode((BNode)resource);
        }
        if (resource instanceof Triple) {
            return this.getMemTriple((Triple)resource);
        }
        if (resource == null) {
            return null;
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public MemIRI getMemURI(IRI uri) {
        if (this.isOwnMemValue((Value)uri)) {
            return (MemIRI)uri;
        }
        return this.iriRegistry.get(uri);
    }

    public MemBNode getMemBNode(BNode bnode) {
        if (this.isOwnMemValue((Value)bnode)) {
            return (MemBNode)bnode;
        }
        return this.bnodeRegistry.get(bnode);
    }

    public MemLiteral getMemLiteral(Literal literal) {
        if (this.isOwnMemValue((Value)literal)) {
            return (MemLiteral)literal;
        }
        return this.literalRegistry.get(literal);
    }

    private boolean isOwnMemValue(Value value) {
        return value instanceof MemValue && ((MemValue)value).getCreator() == this;
    }

    @Deprecated(forRemoval=true, since="4.0.0")
    public Set<MemIRI> getMemURIs() {
        return Collections.unmodifiableSet(this.iriRegistry);
    }

    @Deprecated(forRemoval=true, since="4.0.0")
    public Set<MemBNode> getMemBNodes() {
        return Collections.unmodifiableSet(this.bnodeRegistry);
    }

    @Deprecated(forRemoval=true, since="4.0.0")
    public Set<MemLiteral> getMemLiterals() {
        return Collections.unmodifiableSet(this.literalRegistry);
    }

    public WeakObjectRegistry.AutoCloseableIterator<MemIRI> getMemIRIsIterator() {
        return this.iriRegistry.closeableIterator();
    }

    public WeakObjectRegistry.AutoCloseableIterator<MemBNode> getMemBNodesIterator() {
        return this.bnodeRegistry.closeableIterator();
    }

    public WeakObjectRegistry.AutoCloseableIterator<MemLiteral> getMemLiteralsIterator() {
        return this.literalRegistry.closeableIterator();
    }

    public MemValue getOrCreateMemValue(Value value) {
        if (value instanceof Resource) {
            return this.getOrCreateMemResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getOrCreateMemLiteral((Literal)value);
        }
        throw new IllegalArgumentException("value is not a Resource or Literal: " + value);
    }

    public MemResource getOrCreateMemResource(Resource resource) {
        if (resource instanceof IRI) {
            return this.getOrCreateMemURI((IRI)resource);
        }
        if (resource instanceof BNode) {
            return this.getOrCreateMemBNode((BNode)resource);
        }
        if (resource instanceof Triple) {
            return this.getOrCreateMemTriple((Triple)resource);
        }
        throw new IllegalArgumentException("resource is not a URI or BNode: " + resource);
    }

    public MemIRI getOrCreateMemURI(IRI uri) {
        return this.iriRegistry.getOrAdd(uri, () -> {
            String namespace = uri.getNamespace();
            String sharedNamespace = this.namespaceRegistry.getOrAdd(namespace, () -> namespace);
            return new MemIRI((Object)this, sharedNamespace, uri.getLocalName());
        });
    }

    public MemBNode getOrCreateMemBNode(BNode bnode) {
        return this.bnodeRegistry.getOrAdd(bnode, () -> new MemBNode((Object)this, bnode.getID()));
    }

    public MemLiteral getOrCreateMemLiteral(Literal literal) {
        return this.literalRegistry.getOrAdd(literal, () -> {
            IRI datatype;
            String label = literal.getLabel();
            CoreDatatype coreDatatype = literal.getCoreDatatype();
            IRI iRI = datatype = coreDatatype != CoreDatatype.NONE ? coreDatatype.getIri() : literal.getDatatype();
            if (Literals.isLanguageLiteral((Literal)literal)) {
                return new MemLiteral((Object)this, label, (String)literal.getLanguage().get());
            }
            try {
                if (coreDatatype.isXSDDatatype()) {
                    if (((CoreDatatype.XSD)coreDatatype).isIntegerDatatype()) {
                        return new IntegerMemLiteral((Object)this, label, literal.integerValue(), coreDatatype);
                    }
                    if (coreDatatype == CoreDatatype.XSD.DECIMAL) {
                        return new DecimalMemLiteral((Object)this, label, literal.decimalValue(), coreDatatype);
                    }
                    if (coreDatatype == CoreDatatype.XSD.FLOAT) {
                        return new NumericMemLiteral((Object)this, label, (Number)Float.valueOf(literal.floatValue()), coreDatatype);
                    }
                    if (coreDatatype == CoreDatatype.XSD.DOUBLE) {
                        return new NumericMemLiteral((Object)this, label, (Number)literal.doubleValue(), coreDatatype);
                    }
                    if (coreDatatype == CoreDatatype.XSD.BOOLEAN) {
                        return new BooleanMemLiteral((Object)this, label, literal.booleanValue());
                    }
                    if (coreDatatype == CoreDatatype.XSD.DATETIME) {
                        return new CalendarMemLiteral((Object)this, label, coreDatatype, literal.calendarValue());
                    }
                    if (coreDatatype == CoreDatatype.XSD.DATETIMESTAMP) {
                        return new CalendarMemLiteral((Object)this, label, coreDatatype, literal.calendarValue());
                    }
                }
                return new MemLiteral((Object)this, label, datatype, coreDatatype);
            }
            catch (IllegalArgumentException e) {
                return new MemLiteral((Object)this, label, datatype);
            }
        });
    }

    public IRI createIRI(String uri) {
        return this.getOrCreateMemURI(super.createIRI(uri));
    }

    public IRI createIRI(String namespace, String localName) {
        return this.iriRegistry.getOrAdd(SimpleValueFactory.getInstance().createIRI(namespace, localName), () -> {
            String correctLocalName;
            String correctNamespace;
            if (namespace.indexOf(58) == -1) {
                throw new IllegalArgumentException("Not a valid (absolute) URI: " + namespace + localName);
            }
            if (!URIUtil.isCorrectURISplit((String)namespace, (String)localName)) {
                IRI iri = super.createIRI(namespace + localName);
                correctNamespace = iri.getNamespace();
                correctLocalName = iri.getLocalName();
            } else {
                correctNamespace = namespace;
                correctLocalName = localName;
            }
            String sharedNamespace = this.namespaceRegistry.getOrAdd(correctNamespace, () -> correctNamespace);
            return new MemIRI((Object)this, sharedNamespace, correctLocalName);
        });
    }

    public BNode createBNode(String nodeID) {
        return this.getOrCreateMemBNode(super.createBNode(nodeID));
    }

    public Literal createLiteral(String value) {
        return this.getOrCreateMemLiteral(super.createLiteral(value));
    }

    public Literal createLiteral(String value, String language) {
        return this.getOrCreateMemLiteral(super.createLiteral(value, language));
    }

    public Literal createLiteral(String value, IRI datatype) {
        return this.getOrCreateMemLiteral(super.createLiteral(value, datatype));
    }

    public Literal createLiteral(String value, CoreDatatype datatype) {
        return this.getOrCreateMemLiteral(super.createLiteral(value, datatype));
    }

    public Literal createLiteral(boolean value) {
        BooleanMemLiteral newLiteral = new BooleanMemLiteral((Object)this, value);
        return this.getSharedLiteral(newLiteral);
    }

    public Literal createLiteral(XMLGregorianCalendar calendar) {
        CalendarMemLiteral newLiteral = new CalendarMemLiteral((Object)this, calendar);
        return this.getSharedLiteral(newLiteral);
    }

    private Literal getSharedLiteral(MemLiteral newLiteral) {
        return (Literal)this.literalRegistry.getOrAdd(newLiteral, () -> newLiteral);
    }

    private MemTriple getOrCreateMemTriple(Triple triple) {
        MemTriple memTriple = this.getMemTriple(triple);
        if (memTriple == null) {
            MemTriple newMemTriple = new MemTriple((Object)this, this.getOrCreateMemResource(triple.getSubject()), this.getOrCreateMemURI(triple.getPredicate()), this.getOrCreateMemValue(triple.getObject()));
            boolean wasNew = this.tripleRegistry.add(newMemTriple);
            if (!wasNew) {
                return this.tripleRegistry.getOrAdd(triple, () -> newMemTriple);
            }
            return newMemTriple;
        }
        return memTriple;
    }

    private MemTriple getMemTriple(Triple triple) {
        if (this.isOwnMemValue((Value)triple)) {
            return (MemTriple)triple;
        }
        return this.tripleRegistry.get(triple);
    }
}

