/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TimeDifferencingEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public TimeDifferencingEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size() && this.containedEvaluators.size() != 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one or two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (1 != values.length && values.length != 2) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with 1 or 2 values but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values.length));
        }
        List timeseriesValues = (List)values[0];
        Number lagValue = 1;
        if (1 == values.length) {
            if (!(timeseriesValues instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a List", this.toExpression(this.constructingFactory), values[0].getClass().getSimpleName()));
            }
            if (timeseriesValues.size() <= 1) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found list size of %s for the first value, expecting a List of size > 0.", this.toExpression(this.constructingFactory), timeseriesValues.size()));
            }
        }
        if (2 == values.length) {
            lagValue = (Number)values[1];
            if (!(lagValue instanceof Number)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a Number", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
            }
            if (lagValue.intValue() > timeseriesValues.size()) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found a lag size of %s for the second value, the first value has a List size of %s, expecting a lag value less than the List size", this.toExpression(this.constructingFactory), lagValue.intValue(), timeseriesValues.size()));
            }
        }
        int lag = lagValue.intValue();
        return IntStream.range(lag, timeseriesValues.size()).mapToObj(n -> ((Number)timeseriesValues.get(n)).doubleValue() - ((Number)timeseriesValues.get(n - lag)).doubleValue()).collect(Collectors.toList());
    }
}

