/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.config;

import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.memory.config.MemoryStoreConfig;

public class MemoryStoreFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:MemoryStore";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new MemoryStoreConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        MemoryStore memoryStore = new MemoryStore();
        if (config instanceof MemoryStoreConfig) {
            EvaluationStrategyFactory evalStratFactory;
            MemoryStoreConfig memConfig = (MemoryStoreConfig)config;
            memoryStore.setPersist(memConfig.getPersist());
            memoryStore.setSyncDelay(memConfig.getSyncDelay());
            if (memConfig.getIterationCacheSyncThreshold() > 0L) {
                memoryStore.setIterationCacheSyncThreshold(memConfig.getIterationCacheSyncThreshold());
            }
            if ((evalStratFactory = memConfig.getEvaluationStrategyFactory()) != null) {
                memoryStore.setEvaluationStrategyFactory(evalStratFactory);
            }
        }
        return memoryStore;
    }
}

