/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;

class CloseableIterationSpliterator<T, E extends Exception>
extends Spliterators.AbstractSpliterator<T> {
    private final CloseableIteration<T, E> iteration;

    public CloseableIterationSpliterator(CloseableIteration<T, E> iteration) {
        super(Long.MAX_VALUE, 1280);
        this.iteration = iteration;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action may not be null");
        try {
            if (this.iteration.hasNext()) {
                action.accept(this.iteration.next());
                return true;
            }
            this.iteration.close();
            return false;
        }
        catch (Throwable e) {
            try {
                this.iteration.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action may not be null");
        try (CloseableIteration<T, E> closeableIteration = this.iteration;){
            while (this.iteration.hasNext()) {
                action.accept(this.iteration.next());
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

