/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.sail.SailException;

@InternalUseOnly
public class TripleSourceIterationWrapper<T>
implements CloseableIteration<T, QueryEvaluationException> {
    private final CloseableIteration<? extends T, SailException> delegate;
    private boolean closed = false;

    public TripleSourceIterationWrapper(CloseableIteration<? extends T, SailException> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The iterator was null");
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this.closed) {
            return false;
        }
        try {
            boolean result = this.delegate.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (QueryEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public T next() throws QueryEvaluationException {
        if (this.closed) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        try {
            return (T)this.delegate.next();
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
        catch (IllegalStateException | QueryEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public void remove() throws QueryEvaluationException {
        if (this.closed) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        try {
            this.delegate.remove();
        }
        catch (IllegalStateException | UnsupportedOperationException | QueryEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public final void close() throws QueryEvaluationException {
        if (!this.closed) {
            this.closed = true;
            this.delegate.close();
        }
    }
}

