/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.namespaces;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.common.webapp.views.SimpleResponseView;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class NamespaceController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public NamespaceController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pathInfoStr = request.getPathInfo();
        String prefix = pathInfoStr.substring(pathInfoStr.lastIndexOf(47) + 1);
        String reqMethod = request.getMethod();
        if ("HEAD".equals(reqMethod)) {
            this.logger.info("HEAD namespace for prefix {}", (Object)prefix);
            HashMap model = new HashMap();
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET namespace for prefix {}", (Object)prefix);
            return this.getExportNamespaceResult(request, prefix);
        }
        if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT prefix {}", (Object)prefix);
            return this.getUpdateNamespaceResult(request, prefix);
        }
        if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE prefix {}", (Object)prefix);
            return this.getRemoveNamespaceResult(request, prefix);
        }
        throw new ServerHTTPException("Unexpected request method: " + reqMethod);
    }

    private ModelAndView getExportNamespaceResult(HttpServletRequest request, String prefix) throws ServerHTTPException, ClientHTTPException {
        ModelAndView modelAndView;
        block9: {
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                String namespace = repositoryCon.getNamespace(prefix);
                if (namespace == null) {
                    throw new ClientHTTPException(404, "Undefined prefix: " + prefix);
                }
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("content", namespace);
                modelAndView = new ModelAndView((View)SimpleResponseView.getInstance(), model);
                if (repositoryCon == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repositoryCon != null) {
                        try {
                            repositoryCon.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
                }
            }
            repositoryCon.close();
        }
        return modelAndView;
    }

    private ModelAndView getUpdateNamespaceResult(HttpServletRequest request, String prefix) throws IOException, ClientHTTPException, ServerHTTPException {
        String namespace = IOUtil.readString(request.getReader());
        namespace = namespace.trim();
        this.validateUpdateNamespaceData(prefix, namespace);
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            repositoryCon.setNamespace(prefix, namespace);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }

    private ModelAndView getRemoveNamespaceResult(HttpServletRequest request, String prefix) throws ServerHTTPException {
        try (RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);){
            repositoryCon.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }

    private void validateUpdateNamespaceData(String prefix, String namespace) throws ClientHTTPException {
        if (namespace.length() == 0) {
            throw new ClientHTTPException(400, "No namespace name found in request body");
        }
        if (!StringUtils.isEmpty((CharSequence)prefix) && !StringUtils.isAlphanumeric((CharSequence)prefix)) {
            throw new ClientHTTPException(400, "Prefix not alphanumeric");
        }
        if (!this.isValidNamespaceIri(namespace)) {
            throw new ClientHTTPException(400, "Namespace not valid");
        }
    }

    private boolean isValidNamespaceIri(String namespace) {
        try {
            return new ParsedIRI(namespace).isAbsolute();
        }
        catch (URISyntaxException e) {
            this.logger.debug("Namespace: {} isn't parseable.", (Object)namespace, (Object)e);
            return false;
        }
    }
}

