/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCSVParser
implements ICSVParser {
    protected final char separator;
    protected final char quotechar;
    protected final CSVReaderNullFieldIndicator nullFieldIndicator;
    protected String pending;

    public AbstractCSVParser(char separator, char quotechar, CSVReaderNullFieldIndicator nullFieldIndicator) {
        this.separator = separator;
        this.quotechar = quotechar;
        this.nullFieldIndicator = nullFieldIndicator;
    }

    @Override
    public char getSeparator() {
        return this.separator;
    }

    @Override
    public char getQuotechar() {
        return this.quotechar;
    }

    @Override
    public boolean isPending() {
        return this.pending != null;
    }

    @Override
    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    @Override
    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    @Override
    public String parseToLine(String[] values, boolean applyQuotesToAll) {
        return Stream.of(values).map(v -> this.convertToCsvValue((String)v, applyQuotesToAll)).collect(Collectors.joining(Character.toString(this.getSeparator())));
    }

    protected abstract String convertToCsvValue(String var1, boolean var2);

    protected boolean isSurroundWithQuotes(String value, boolean forceSurround) {
        if (value == null) {
            return this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_QUOTES);
        }
        if (value.isEmpty() && this.nullFieldIndicator.equals((Object)CSVReaderNullFieldIndicator.EMPTY_SEPARATORS)) {
            return true;
        }
        return forceSurround || value.contains(Character.toString(this.getSeparator())) || value.contains("\n");
    }

    protected abstract String[] parseLine(String var1, boolean var2) throws IOException;

    @Override
    public CSVReaderNullFieldIndicator nullFieldIndicator() {
        return this.nullFieldIndicator;
    }

    @Override
    public String getPendingText() {
        return StringUtils.defaultString((String)this.pending);
    }
}

