/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base.config;

import java.util.Optional;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.base.config.BaseSailSchema;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

public abstract class BaseSailConfig
extends AbstractSailImplConfig {
    private String evalStratFactoryClassName;
    private QueryEvaluationMode defaultQueryEvaluationMode;

    protected BaseSailConfig(String type) {
        super(type);
    }

    public String getEvaluationStrategyFactoryClassName() {
        return this.evalStratFactoryClassName;
    }

    public void setEvaluationStrategyFactoryClassName(String className) {
        this.evalStratFactoryClassName = className;
    }

    public EvaluationStrategyFactory getEvaluationStrategyFactory() throws SailConfigException {
        if (this.evalStratFactoryClassName == null) {
            return null;
        }
        try {
            EvaluationStrategyFactory factory = (EvaluationStrategyFactory)Thread.currentThread().getContextClassLoader().loadClass(this.evalStratFactoryClassName).newInstance();
            return factory;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SailConfigException(e);
        }
    }

    @Override
    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        if (this.evalStratFactoryClassName != null) {
            graph.setNamespace("sb", "http://www.openrdf.org/config/sail/base#");
            graph.add(implNode, BaseSailSchema.EVALUATION_STRATEGY_FACTORY, Values.literal(this.evalStratFactoryClassName), new Resource[0]);
        }
        this.getDefaultQueryEvaluationMode().ifPresent(mode -> {
            graph.setNamespace("sb", "http://www.openrdf.org/config/sail/base#");
            graph.add(implNode, BaseSailSchema.DEFAULT_QUERY_EVALUATION_MODE, Values.literal(mode.getValue()), new Resource[0]);
        });
        return implNode;
    }

    @Override
    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Models.objectLiteral(graph.getStatements(implNode, BaseSailSchema.DEFAULT_QUERY_EVALUATION_MODE, null, new Resource[0])).ifPresent(qem -> this.setDefaultQueryEvaluationMode(QueryEvaluationMode.valueOf(qem.stringValue())));
            Models.objectLiteral(graph.getStatements(implNode, BaseSailSchema.EVALUATION_STRATEGY_FACTORY, null, new Resource[0])).ifPresent(factoryClassName -> this.setEvaluationStrategyFactoryClassName(factoryClassName.stringValue()));
        }
        catch (IllegalArgumentException | ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }

    public Optional<QueryEvaluationMode> getDefaultQueryEvaluationMode() {
        return Optional.ofNullable(this.defaultQueryEvaluationMode);
    }

    public void setDefaultQueryEvaluationMode(QueryEvaluationMode defaultQueryEvaluationMode) {
        this.defaultQueryEvaluationMode = defaultQueryEvaluationMode;
    }
}

