/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NonUniqueTargetLang;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class UniqueLangConstraintComponent
extends AbstractConstraintComponent {
    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.UNIQUE_LANG, BooleanLiteral.TRUE, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.UniqueLangConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Object query = effectiveTarget.getQuery(false);
        StatementMatcher.Variable<Value> value1 = stableRandomVariableProvider.next();
        String pathQuery1 = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value1, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
        query = (String)query + "\n" + pathQuery1;
        StatementMatcher.Variable<Value> value2 = stableRandomVariableProvider.next();
        String pathQuery2 = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value2, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of())).orElseThrow(IllegalStateException::new).getFragment();
        query = (String)query + "\n" + String.join((CharSequence)"\n", UniqueLangConstraintComponent.trim("", "FILTER(", "\tEXISTS {", "\t\t" + pathQuery2, "\t\tFILTER(", "\t\t\tlang(" + value2.asSparqlVariable() + ") != \"\" && ", "\t\t\tlang(" + value1.asSparqlVariable() + ") != \"\" && ", "\t\t\t" + value1.asSparqlVariable() + " != " + value2.asSparqlVariable() + " && ", "\t\t\tlang(" + value1.asSparqlVariable() + ") = lang(" + value2.asSparqlVariable() + ")", "\t\t)", "\t}", ")"));
        List<StatementMatcher.Variable<Value>> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(this.getTargetChain().getNamespaces(), (String)query, allTargetVariables, null, scope, this, null, null);
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Optional<Path> path = this.getTargetChain().getPath();
        if (!path.isPresent() || scope != ConstraintComponent.Scope.propertyShape) {
            throw new IllegalStateException("UniqueLang only operates on paths");
        }
        if (overrideTargetNode != null) {
            PlanNode targets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
            BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(targets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()));
            NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(relevantTargetsWithPath);
            return Unique.getInstance(new TrimToTarget(nonUniqueTargetLang), false);
        }
        if (connectionsGroup.getStats().wasEmptyBeforeTransaction()) {
            PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            PlanNode addedByPath = path.get().getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
            PlanNode innerJoin = new InnerJoin(addedTargets, addedByPath).getJoined(UnBufferedPlanNode.class);
            NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(innerJoin);
            return Unique.getInstance(new TrimToTarget(nonUniqueTargetLang), false);
        }
        PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
        PlanNode addedByPath = path.get().getAllAdded(connectionsGroup, validationSettings.getDataGraph(), null);
        addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), Unique.getInstance(new TrimToTarget(addedByPath), false));
        addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.left, false, null);
        PlanNode mergeNode = UnionNode.getInstance(addedTargets, addedByPath);
        mergeNode = new TrimToTarget(mergeNode);
        PlanNode allRelevantTargets = Unique.getInstance(mergeNode, false);
        BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(allRelevantTargets, connectionsGroup.getBaseConnection(), validationSettings.getDataGraph(), path.get().getTargetQueryFragment(new StatementMatcher.Variable<String>("a"), new StatementMatcher.Variable<String>("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of()), false, null, BulkedExternalInnerJoin.getMapper("a", "c", scope, validationSettings.getDataGraph()));
        NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(relevantTargetsWithPath);
        return Unique.getInstance(new TrimToTarget(nonUniqueTargetLang), false);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            return Unique.getInstance(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return EmptyNode.getInstance();
    }

    @Override
    public ConstraintComponent deepClone() {
        return new UniqueLangConstraintComponent();
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }
}

