/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.BackwardChainingShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.Rdf4jShaclShapeGraphShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;

public class CombinedShapeSource
implements ShapeSource {
    private final Rdf4jShaclShapeGraphShapeSource rdf4jShapesGraph;
    private final BackwardChainingShapeSource baseSail;
    private final Resource[] context;

    public CombinedShapeSource(SailConnection shapesForForwardChainingConnection, SailConnection sailConnection) {
        this(shapesForForwardChainingConnection, sailConnection, null);
    }

    public CombinedShapeSource(RepositoryConnection shapesForForwardChainingConnection, SailConnection sailConnection) {
        this(shapesForForwardChainingConnection, sailConnection, null);
    }

    private CombinedShapeSource(RepositoryConnection shapesForForwardChainingConnection, SailConnection sailConnection, Resource[] context) {
        this.rdf4jShapesGraph = new Rdf4jShaclShapeGraphShapeSource(shapesForForwardChainingConnection);
        this.baseSail = new BackwardChainingShapeSource(sailConnection);
        this.context = context;
    }

    private CombinedShapeSource(SailConnection shapesForForwardChainingConnection, SailConnection sailConnection, Resource[] context) {
        this.rdf4jShapesGraph = new Rdf4jShaclShapeGraphShapeSource(shapesForForwardChainingConnection);
        this.baseSail = new BackwardChainingShapeSource(sailConnection);
        this.context = context;
    }

    private CombinedShapeSource(Rdf4jShaclShapeGraphShapeSource rdf4jShapesGraph, BackwardChainingShapeSource baseSail, Resource[] context) {
        this.rdf4jShapesGraph = rdf4jShapesGraph;
        this.baseSail = baseSail;
        this.context = context;
    }

    @Override
    public ShapeSource withContext(Resource[] context) {
        boolean contextContainRdf4jShapeGraph = false;
        boolean contextContainsOtherShapesGraph = false;
        for (Resource resource : context) {
            if (RDF4J.SHACL_SHAPE_GRAPH.equals((Object)resource)) {
                contextContainRdf4jShapeGraph = true;
                continue;
            }
            contextContainsOtherShapesGraph = true;
        }
        if (contextContainRdf4jShapeGraph && !contextContainsOtherShapesGraph) {
            return this.rdf4jShapesGraph.withContext(context);
        }
        if (!contextContainRdf4jShapeGraph && contextContainsOtherShapesGraph) {
            return this.baseSail.withContext(context);
        }
        Resource[] context1 = new Resource[]{RDF4J.SHACL_SHAPE_GRAPH};
        Resource[] context2 = (Resource[])Arrays.stream(context).filter(c -> !RDF4J.SHACL_SHAPE_GRAPH.equals(c)).toArray(Resource[]::new);
        return new CombinedShapeSource(this.rdf4jShapesGraph.withContext(context1), this.baseSail.withContext(context2), context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        return Stream.concat(this.rdf4jShapesGraph.getAllShapeContexts(), this.baseSail.getAllShapeContexts());
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.concat(this.rdf4jShapesGraph.getTargetableShape(), this.baseSail.getTargetableShape()).distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        return this.rdf4jShapesGraph.isType(subject, type) || this.baseSail.isType(subject, type);
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return Stream.concat(this.rdf4jShapesGraph.getSubjects(predicate), this.baseSail.getSubjects(predicate)).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return Stream.concat(this.rdf4jShapesGraph.getObjects(subject, predicate), this.baseSail.getObjects(subject, predicate)).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return Stream.concat(this.rdf4jShapesGraph.getAllStatements(id), this.baseSail.getAllStatements(id)).distinct();
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        assert (this.context != null);
        Value rdfFirst1 = this.rdf4jShapesGraph.getRdfFirst(subject);
        return rdfFirst1 != null ? rdfFirst1 : this.baseSail.getRdfFirst(subject);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        assert (this.context != null);
        Resource rdfRest1 = this.rdf4jShapesGraph.getRdfRest(subject);
        return rdfRest1 != null ? rdfRest1 : this.baseSail.getRdfRest(subject);
    }

    @Override
    public void close() {
        this.rdf4jShapesGraph.close();
        this.baseSail.close();
    }
}

