/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.rdf;

import java.util.function.Consumer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.builder.EmptyPropertyPathBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectList;

public interface RdfSubject
extends QueryElement {
    default public TriplePattern has(RdfPredicate predicate, RdfObject ... objects) {
        return GraphPatterns.tp(this, predicate, objects);
    }

    default public TriplePattern has(IRI predicate, RdfObject ... objects) {
        return this.has((RdfPredicate)Rdf.iri(predicate), objects);
    }

    default public TriplePattern has(RdfPredicate predicate, Value ... values) {
        return this.has(predicate, Rdf.objects(values));
    }

    default public TriplePattern has(IRI predicate, Value ... values) {
        return this.has((RdfPredicate)Rdf.iri(predicate), Rdf.objects(values));
    }

    default public TriplePattern has(RdfPredicateObjectList ... lists) {
        return GraphPatterns.tp(this, lists);
    }

    default public TriplePattern has(RdfPredicate predicate, String ... objects) {
        return GraphPatterns.tp(this, predicate, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(IRI predicate, String ... objects) {
        return GraphPatterns.tp(this, (RdfPredicate)Rdf.iri(predicate), (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(RdfPredicate predicate, Number ... objects) {
        return GraphPatterns.tp(this, predicate, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(IRI predicate, Number ... objects) {
        return GraphPatterns.tp(this, (RdfPredicate)Rdf.iri(predicate), (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(RdfPredicate predicate, Boolean ... objects) {
        return GraphPatterns.tp(this, predicate, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(IRI predicate, Boolean ... objects) {
        return GraphPatterns.tp(this, (RdfPredicate)Rdf.iri(predicate), (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern isA(RdfObject ... objects) {
        return this.has(RdfPredicate.a, objects);
    }

    default public TriplePattern isA(IRI ... objects) {
        return this.has(RdfPredicate.a, (Value[])objects);
    }

    default public TriplePattern has(Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, RdfObject ... objects) {
        EmptyPropertyPathBuilder pathBuilder = new EmptyPropertyPathBuilder();
        propertyPathConfigurer.accept(pathBuilder);
        return GraphPatterns.tp(this, (RdfPredicate)pathBuilder.build(), objects);
    }

    default public TriplePattern has(Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, Value ... objects) {
        return this.has(propertyPathConfigurer, Rdf.objects(objects));
    }

    default public TriplePattern has(Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, String ... objects) {
        return this.has(propertyPathConfigurer, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, Number ... objects) {
        return this.has(propertyPathConfigurer, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }

    default public TriplePattern has(Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, Boolean ... objects) {
        return this.has(propertyPathConfigurer, (RdfObject[])Rdf.toRdfLiteralArray(objects));
    }
}

