/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response.json;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.response.json.BucketBasedJsonFacet;
import org.apache.solr.client.solrj.response.json.HeatmapJsonFacet;
import org.apache.solr.common.util.NamedList;

public class NestableJsonFacet {
    private long domainCount;
    private final Map<String, NestableJsonFacet> queryFacetsByName = new HashMap<String, NestableJsonFacet>();
    private final Map<String, BucketBasedJsonFacet> bucketBasedFacetByName = new HashMap<String, BucketBasedJsonFacet>();
    private final Map<String, Number> statFacetsByName = new HashMap<String, Number>();
    private final Map<String, Object> statsByName;
    private final Map<String, HeatmapJsonFacet> heatmapFacetsByName = new HashMap<String, HeatmapJsonFacet>();

    public NestableJsonFacet(NamedList<Object> facetNL) {
        this.statsByName = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : facetNL) {
            String key = entry.getKey();
            if (this.getKeysToSkip().contains(key)) continue;
            if ("count".equals(key)) {
                this.domainCount = ((Number)entry.getValue()).longValue();
                continue;
            }
            if (entry.getValue() instanceof Number) {
                this.statFacetsByName.put(key, (Number)entry.getValue());
                this.statsByName.put(key, (Number)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String || entry.getValue() instanceof Date) {
                this.statsByName.put(key, entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof NamedList)) continue;
            NamedList facet = (NamedList)entry.getValue();
            boolean isBucketBased = facet.get("buckets") != null;
            boolean isHeatmap = HeatmapJsonFacet.isHeatmapFacet(facet);
            if (isBucketBased) {
                this.bucketBasedFacetByName.put(key, new BucketBasedJsonFacet(facet));
                continue;
            }
            if (isHeatmap) {
                this.heatmapFacetsByName.put(key, new HeatmapJsonFacet(facet));
                continue;
            }
            this.queryFacetsByName.put(key, new NestableJsonFacet(facet));
        }
    }

    public long getCount() {
        return this.domainCount;
    }

    public NestableJsonFacet getQueryFacet(String name) {
        return this.queryFacetsByName.get(name);
    }

    public Set<String> getQueryFacetNames() {
        return this.queryFacetsByName.keySet();
    }

    public BucketBasedJsonFacet getBucketBasedFacets(String name) {
        return this.bucketBasedFacetByName.get(name);
    }

    public Set<String> getBucketBasedFacetNames() {
        return this.bucketBasedFacetByName.keySet();
    }

    public Number getStatFacetValue(String name) {
        return this.statFacetsByName.get(name);
    }

    public Object getStatValue(String name) {
        return this.statsByName.get(name);
    }

    public Set<String> getStatFacetNames() {
        return this.statFacetsByName.keySet();
    }

    public Set<String> getStatNames() {
        return this.statsByName.keySet();
    }

    public HeatmapJsonFacet getHeatmapFacetByName(String name) {
        return this.heatmapFacetsByName.get(name);
    }

    public Set<String> getHeatmapFacetNames() {
        return this.heatmapFacetsByName.keySet();
    }

    protected Set<String> getKeysToSkip() {
        HashSet<String> keysToSkip = new HashSet<String>();
        return keysToSkip;
    }
}

