/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class CrossProductIteration
extends LookAheadIteration<BindingSet> {
    protected final List<BindingSet> inputBindings;
    protected final CloseableIteration<BindingSet> resultIteration;
    protected Iterator<BindingSet> inputBindingsIterator = null;
    protected BindingSet currentInputBinding = null;

    public CrossProductIteration(CloseableIteration<BindingSet> resultIteration, List<BindingSet> inputBindings) {
        this.resultIteration = resultIteration;
        this.inputBindings = inputBindings;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.currentInputBinding == null) {
            this.inputBindingsIterator = this.inputBindings.iterator();
            if (this.resultIteration.hasNext()) {
                this.currentInputBinding = (BindingSet)this.resultIteration.next();
            } else {
                return null;
            }
        }
        if (this.inputBindingsIterator.hasNext()) {
            BindingSet next = this.inputBindingsIterator.next();
            QueryBindingSet res = new QueryBindingSet(next.size() + this.currentInputBinding.size());
            res.addAll(next);
            res.addAll(this.currentInputBinding);
            if (!this.inputBindingsIterator.hasNext()) {
                this.currentInputBinding = null;
            }
            return res;
        }
        return null;
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.resultIteration.close();
        }
    }
}

