/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.loader;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdErrorCode;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.loader.DocumentLoaderOptions;
import no.hasmac.jsonld.loader.FileLoader;
import no.hasmac.jsonld.loader.HttpLoader;

public final class SchemeRouter
implements DocumentLoader {
    private static final DocumentLoader INSTANCE = new SchemeRouter().set("http", HttpLoader.defaultInstance()).set("https", HttpLoader.defaultInstance()).set("file", new FileLoader());
    private final Map<String, DocumentLoader> loaders = new LinkedHashMap<String, DocumentLoader>();

    public static DocumentLoader defaultInstance() {
        return INSTANCE;
    }

    public SchemeRouter set(String scheme, DocumentLoader loader) {
        this.loaders.put(scheme, loader);
        return this;
    }

    @Override
    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        if (url == null) {
            throw new IllegalArgumentException("The url must not be null.");
        }
        DocumentLoader loader = this.loaders.getOrDefault(url.getScheme().toLowerCase(), null);
        if (loader == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "URL scheme [" + url.getScheme() + "] is not supported.");
        }
        return loader.loadDocument(url, options);
    }
}

