/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableObjectCharMapFactory;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.impl.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectCharHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableObjectCharMapFactoryImpl implements MutableObjectCharMapFactory
{
    INSTANCE;


    public <K> MutableObjectCharMap<K> empty() {
        return new ObjectCharHashMap(0);
    }

    public <K> MutableObjectCharMap<K> of() {
        return this.empty();
    }

    public <K> MutableObjectCharMap<K> with() {
        return this.empty();
    }

    public <K> MutableObjectCharMap<K> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public <K> MutableObjectCharMap<K> withInitialCapacity(int capacity) {
        return new ObjectCharHashMap(capacity);
    }

    public <K> MutableObjectCharMap<K> ofAll(ObjectCharMap<? extends K> map) {
        return this.withAll(map);
    }

    public <K> MutableObjectCharMap<K> withAll(ObjectCharMap<? extends K> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ObjectCharHashMap<K>(map);
    }

    public <T, K> MutableObjectCharMap<K> from(Iterable<T> iterable, Function<? super T, ? extends K> keyFunction, CharFunction<? super T> valueFunction) {
        MutableObjectCharMap map = ObjectCharMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.valueOf(each), valueFunction.charValueOf(each)));
        return map;
    }
}

