/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import no.hasmac.jsonld.lang.LanguageTagParser;

public final class LanguageTag {
    private String language;
    private Collection<String> languageExtensions;
    private String script;
    private String region;
    private Collection<Extension> extensions;
    private Collection<String> variants;
    private Collection<String> privateUse;

    LanguageTag() {
    }

    public static boolean isWellFormed(String languageTag) {
        if (languageTag == null) {
            throw new IllegalArgumentException("The parameter 'laguageTag' must not be null");
        }
        return LanguageTagParser.isWellFormed(languageTag);
    }

    public static LanguageTag create(String languageTag) {
        if (languageTag == null) {
            throw new IllegalArgumentException("The parameter 'laguageTag' must not be null");
        }
        return LanguageTagParser.create(languageTag).parse();
    }

    public String getLanguage() {
        return this.language;
    }

    public Collection<String> getLanguageExtensions() {
        return this.languageExtensions;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public Collection<String> getVariants() {
        return this.variants;
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }

    public Collection<String> getPrivateUse() {
        return this.privateUse;
    }

    protected void setLanguage(String language) {
        this.language = language;
    }

    protected void addLanguageExtension(String languageExtension) {
        if (this.languageExtensions == null) {
            this.languageExtensions = new ArrayList<String>();
        }
        this.languageExtensions.add(languageExtension);
    }

    protected void setScript(String script) {
        this.script = script;
    }

    protected void setRegion(String region) {
        this.region = region;
    }

    protected void addVariant(String variant) {
        if (this.variants == null) {
            this.variants = new ArrayList<String>();
        }
        this.variants.add(variant);
    }

    protected void addExtension(Extension extension) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        this.extensions.add(extension);
    }

    protected void addPrivateUse(String privateTag) {
        if (this.privateUse == null) {
            this.privateUse = new ArrayList<String>();
        }
        this.privateUse.add(privateTag);
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.language, this.languageExtensions, this.privateUse, this.region, this.script, this.variants);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageTag other = (LanguageTag)obj;
        return Objects.equals(this.extensions, other.extensions) && Objects.equals(this.language, other.language) && Objects.equals(this.languageExtensions, other.languageExtensions) && Objects.equals(this.privateUse, other.privateUse) && Objects.equals(this.region, other.region) && Objects.equals(this.script, other.script) && Objects.equals(this.variants, other.variants);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.language);
        if (this.languageExtensions != null) {
            this.languageExtensions.forEach(tag -> {
                sb.append('-');
                sb.append((String)tag);
            });
        }
        if (this.script != null) {
            sb.append('-');
            sb.append(this.script);
        }
        if (this.region != null) {
            sb.append('-');
            sb.append(this.region);
        }
        if (this.variants != null) {
            this.variants.forEach(tag -> {
                sb.append('-');
                sb.append((String)tag);
            });
        }
        if (this.extensions != null) {
            this.extensions.forEach(tag -> {
                sb.append('-');
                sb.append(tag);
            });
        }
        if (this.privateUse != null) {
            sb.append('-');
            sb.append('x');
            this.privateUse.forEach(tag -> {
                sb.append('-');
                sb.append((String)tag);
            });
        }
        return sb.toString();
    }

    public static class Extension {
        private char code;
        private Collection<String> tags;

        public Extension(char code, Collection<String> tags) {
            this.code = code;
            this.tags = tags;
        }

        protected void addTag(String tag) {
            this.tags.add(tag);
        }

        public char getCode() {
            return this.code;
        }

        public Collection<String> getTags() {
            return this.tags;
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.code), this.tags);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Extension other = (Extension)obj;
            return this.code == other.code && Objects.equals(this.tags, other.tags);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.code);
            this.tags.forEach(tag -> {
                sb.append('-');
                sb.append((String)tag);
            });
            return sb.toString();
        }
    }
}

