/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S2LatLng;

public strictfp class S2Point
implements Comparable<S2Point> {
    final double x;
    final double y;
    final double z;

    public S2Point() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public S2Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static S2Point minus(S2Point p1, S2Point p2) {
        return S2Point.sub(p1, p2);
    }

    public static S2Point neg(S2Point p) {
        return new S2Point(-p.x, -p.y, -p.z);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public static S2Point crossProd(S2Point p1, S2Point p2) {
        return new S2Point(p1.y * p2.z - p1.z * p2.y, p1.z * p2.x - p1.x * p2.z, p1.x * p2.y - p1.y * p2.x);
    }

    public static S2Point add(S2Point p1, S2Point p2) {
        return new S2Point(p1.x + p2.x, p1.y + p2.y, p1.z + p2.z);
    }

    public static S2Point sub(S2Point p1, S2Point p2) {
        return new S2Point(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z);
    }

    public double dotProd(S2Point that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public static S2Point mul(S2Point p, double m) {
        return new S2Point(m * p.x, m * p.y, m * p.z);
    }

    public static S2Point div(S2Point p, double m) {
        return new S2Point(p.x / m, p.y / m, p.z / m);
    }

    public S2Point ortho() {
        int k = this.largestAbsComponent();
        S2Point temp = k == 1 ? new S2Point(1.0, 0.0, 0.0) : (k == 2 ? new S2Point(0.0, 1.0, 0.0) : new S2Point(0.0, 0.0, 1.0));
        return S2Point.normalize(S2Point.crossProd(this, temp));
    }

    public int largestAbsComponent() {
        S2Point temp = S2Point.fabs(this);
        if (temp.x > temp.y) {
            if (temp.x > temp.z) {
                return 0;
            }
            return 2;
        }
        if (temp.y > temp.z) {
            return 1;
        }
        return 2;
    }

    public static S2Point fabs(S2Point p) {
        return new S2Point(Math.abs(p.x), Math.abs(p.y), Math.abs(p.z));
    }

    public static S2Point normalize(S2Point p) {
        double norm = p.norm();
        if (norm != 0.0) {
            norm = 1.0 / norm;
        }
        return S2Point.mul(p, norm);
    }

    public double get(int axis) {
        return axis == 0 ? this.x : (axis == 1 ? this.y : this.z);
    }

    public double angle(S2Point va) {
        return Math.atan2(S2Point.crossProd(this, va).norm(), this.dotProd(va));
    }

    boolean aequal(S2Point that, double margin) {
        return Math.abs(this.x - that.x) < margin && Math.abs(this.y - that.y) < margin && Math.abs(this.z - that.z) < margin;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Point)) {
            return false;
        }
        S2Point thatPoint = (S2Point)that;
        return this.x == thatPoint.x && this.y == thatPoint.y && this.z == thatPoint.z;
    }

    public boolean lessThan(S2Point vb) {
        if (this.x < vb.x) {
            return true;
        }
        if (vb.x < this.x) {
            return false;
        }
        if (this.y < vb.y) {
            return true;
        }
        if (vb.y < this.y) {
            return false;
        }
        return this.z < vb.z;
    }

    @Override
    public int compareTo(S2Point other) {
        return this.lessThan(other) ? -1 : (this.equals(other) ? 0 : 1);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public String toDegreesString() {
        S2LatLng s2LatLng = new S2LatLng(this);
        return "(" + Double.toString(s2LatLng.latDegrees()) + ", " + Double.toString(s2LatLng.lngDegrees()) + ")";
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.x));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.y));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.z));
        return (int)(value ^ value >>> 32);
    }
}

