/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.util.Comparator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.dataviewers.STDataViewersActivator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.swt.widgets.Item;

public class STDataViewersComparator
extends ViewerComparator
implements Comparator<Object> {
    public static final int MAX_DEPTH = 4;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    protected final Item[] columns;
    protected int[] priorities;
    protected int[] directions;

    public STDataViewersComparator(STDataViewersComparator other) {
        this(other.getColumns(), other.getPriorities(), other.getDirections());
    }

    public STDataViewersComparator(Item[] columns) {
        this(columns, null, null);
    }

    private STDataViewersComparator(Item[] columns, int[] priorities, int[] directions) {
        this.columns = columns;
        if (priorities == null || directions == null) {
            this.priorities = new int[columns.length];
            this.directions = new int[columns.length];
            this.resetState();
        } else if (priorities.length == columns.length && directions.length == columns.length) {
            this.priorities = priorities;
            this.directions = directions;
        } else {
            STDataViewersActivator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.linuxtools.dataviewers", "Invalid parameters: priorities and/or directions number don't match with viewer's columns count. Applying defaults settings."));
            this.resetState();
        }
    }

    private void resetPriorites() {
        int i = 0;
        while (i < this.priorities.length) {
            this.priorities[i] = i;
            ++i;
        }
    }

    private void resetDirections() {
        int i = 0;
        while (i < this.directions.length) {
            this.directions[i] = this.getField(this.columns[i]).getDefaultDirection();
            ++i;
        }
    }

    public void resetState() {
        this.resetDirections();
        this.resetPriorites();
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void setTopPriority(Item column, ISTDataViewersField field) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].equals(column)) {
                this.setTopPriority(i, field);
            }
            ++i;
        }
    }

    private void setTopPriority(int priority, ISTDataViewersField field) {
        if (priority < 0 || priority >= this.priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.priorities.length) {
            if (this.priorities[i] == priority) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            this.resetState();
            return;
        }
        i = index;
        while (i > 0) {
            this.priorities[i] = this.priorities[i - 1];
            --i;
        }
        this.priorities[0] = priority;
        this.directions[priority] = field.getDefaultDirection();
    }

    public void setTopPriorityDirection(int direction) {
        if (direction == 1 || direction == -1) {
            this.directions[this.priorities[0]] = direction;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public Item getTopColumn() {
        return this.columns[this.priorities[0]];
    }

    public int[] getPriorities() {
        int[] copy = new int[this.priorities.length];
        System.arraycopy(this.priorities, 0, copy, 0, copy.length);
        return copy;
    }

    public int[] getDirections() {
        int[] copy = new int[this.directions.length];
        System.arraycopy(this.directions, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare(o1, o2, 0, true);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compare(e1, e2, 0, true);
    }

    private int compare(Object obj1, Object obj2, int depth, boolean continueSearching) {
        if (depth >= this.priorities.length) {
            return 0;
        }
        int column = this.priorities[depth];
        ISTDataViewersField property = this.getField(this.columns[column]);
        int result = this.directions[column] >= 0 ? property.compare(obj1, obj2) : property.compare(obj2, obj1);
        if (result == 0 && continueSearching) {
            return this.compare(obj1, obj2, depth + 1, continueSearching);
        }
        return result;
    }

    protected ISTDataViewersField getField(Item column) {
        return (ISTDataViewersField)column.getData();
    }

    public Item[] getColumns() {
        return this.columns;
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            return;
        }
        IDialogSettings settings = dialogSettings.getSection("sorter_section");
        if (settings == null) {
            settings = dialogSettings.addNewSection("sorter_section");
        }
        int i = 0;
        while (i < this.priorities.length) {
            settings.put("sort_priority_" + i, this.priorities[i]);
            settings.put("sort_direction_" + i, this.directions[i]);
            ++i;
        }
    }

    public void restoreState(IDialogSettings dialogSettings) {
        if (dialogSettings == null) {
            this.resetState();
            return;
        }
        IDialogSettings settings = dialogSettings.getSection("sorter_section");
        if (settings == null) {
            this.resetState();
            return;
        }
        try {
            int i = 0;
            while (i < this.priorities.length) {
                String priority = settings.get("sort_priority_" + i);
                if (priority == null) {
                    this.resetState();
                    return;
                }
                int colIndex = Integer.parseInt(priority);
                if (colIndex >= this.columns.length) {
                    this.resetState();
                    return;
                }
                this.priorities[i] = colIndex;
                String direction = settings.get("sort_direction_" + i);
                if (direction == null) {
                    this.resetState();
                    return;
                }
                this.directions[i] = Integer.parseInt(direction);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            this.resetState();
            return;
        }
    }
}

