/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.dialogs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.ComposerUIPluginImages;
import org.eclipse.php.composer.ui.controller.PathController;
import org.eclipse.php.composer.ui.dialogs.Messages;
import org.eclipse.php.composer.ui.dialogs.ResourceDialog;
import org.eclipse.php.composer.ui.utils.WidgetHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class PsrDialog
extends Dialog {
    private Text namespaceControl;
    private Namespace namespace;
    private IProject project;
    private TableViewer pathViewer;

    public PsrDialog(Shell parentShell, Namespace namespace, IProject project) {
        super(parentShell);
        this.namespace = namespace;
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.PsrDialog_Title);
        this.getShell().setImage(ComposerUIPluginImages.EVENT.createImage());
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        GridData gd_contents = new GridData();
        gd_contents.widthHint = 350;
        contents.setLayoutData((Object)gd_contents);
        Label lblEvent = new Label(contents, 0);
        GridData gd_lblEvent = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblEvent.widthHint = 100;
        lblEvent.setLayoutData((Object)gd_lblEvent);
        lblEvent.setText(Messages.PsrDialog_NamespaceLabel);
        this.namespaceControl = new Text(contents, 2048);
        GridData gd_eventControl = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_eventControl.widthHint = 175;
        this.namespaceControl.setLayoutData((Object)gd_eventControl);
        this.namespaceControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PsrDialog.this.namespace.setNamespace(PsrDialog.this.namespaceControl.getText());
            }
        });
        if (this.namespace.getNamespace() != null) {
            this.namespaceControl.setText(this.namespace.getNamespace());
        } else {
            this.namespaceControl.setText("");
        }
        Label lblHandler = new Label(contents, 0);
        lblHandler.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        lblHandler.setText(Messages.PsrDialog_PathsLabel);
        PathController controller = new PathController();
        this.pathViewer = new TableViewer(contents, 67584);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.minimumHeight = 100;
        this.pathViewer.getTable().setLayoutData((Object)gridData);
        this.pathViewer.setContentProvider((IContentProvider)controller);
        this.pathViewer.setLabelProvider((IBaseLabelProvider)controller);
        this.pathViewer.setInput((Object)this.namespace.getPaths());
        Composite buttons = new Composite(contents, 0);
        buttons.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        buttons.setLayout((Layout)new GridLayout(1, false));
        WidgetHelper.trimComposite(buttons, 0);
        WidgetHelper.setMargin(buttons, 1, 1);
        WidgetHelper.setSpacing(buttons, 0, 0);
        Button btnEdit = new Button(buttons, 8);
        btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnEdit.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnEdit.setText(Messages.PsrDialog_EditButton);
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<IFolder> folders = new ArrayList<IFolder>();
                for (Object path : PsrDialog.this.namespace.getPaths()) {
                    IResource resource = PsrDialog.this.project.findMember((String)path);
                    if (resource == null || !(resource instanceof IFolder)) continue;
                    folders.add((IFolder)resource);
                }
                CheckedTreeSelectionDialog dialog = ResourceDialog.createMulti(PsrDialog.this.pathViewer.getTable().getShell(), Messages.PsrDialog_SelectionDialogTitle, Messages.PsrDialog_SelectionDialogMessage, new Class[]{IFolder.class}, PsrDialog.this.project, folders);
                if (dialog.open() == 0) {
                    PsrDialog.this.namespace.clear();
                    Object[] objectArray = dialog.getResult();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IFolder) {
                            PsrDialog.this.namespace.add(((IFolder)result).getProjectRelativePath().toString());
                        }
                        ++n2;
                    }
                }
            }
        });
        Button btnRemove = new Button(buttons, 0);
        btnRemove.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnRemove.setText(Messages.PsrDialog_RemoveButton);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = PsrDialog.this.pathViewer.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection s = (StructuredSelection)selection;
                Object[] objectArray = s.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    try {
                        String item = (String)o;
                        PsrDialog.this.pathViewer.remove((Object)item);
                        PsrDialog.this.namespace.remove(item);
                    }
                    catch (Exception e2) {
                        Logger.logException((Throwable)e2);
                    }
                    ++n2;
                }
            }
        });
        this.namespace.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().contains("#")) {
                    if (PsrDialog.this.pathViewer.getControl().isDisposed()) {
                        return;
                    }
                    PsrDialog.this.pathViewer.refresh();
                }
            }
        });
        return contents;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

