/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.ast.nodes.TraitStatement;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class ClassHighlighting
extends AbstractSemanticHighlighting {
    public static final String SELF = "self";
    public static final String PARENT = "parent";
    public static final String CLASS = "class";

    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new ClassApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(true).setDefaultTextColor(0, 80, 50);
    }

    public String getDisplayName() {
        return Messages.ClassHighlighting_0;
    }

    protected class ClassApply
    extends AbstractSemanticApply {
        protected ClassApply() {
        }

        public boolean visit(InterfaceDeclaration interfaceDeclaration) {
            ClassHighlighting.this.highlight((ASTNode)interfaceDeclaration.getName());
            for (Identifier identifier : interfaceDeclaration.interfaces()) {
                if (identifier instanceof NamespaceName) {
                    this.highlightNamespaceType((NamespaceName)identifier);
                    continue;
                }
                ClassHighlighting.this.highlight((ASTNode)identifier);
            }
            return true;
        }

        public boolean visit(ClassDeclaration clazz) {
            ClassHighlighting.this.highlight((ASTNode)clazz.getName());
            Expression superClass = clazz.getSuperClass();
            if (superClass instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)superClass);
            } else if (superClass != null) {
                ClassHighlighting.this.highlight((ASTNode)superClass);
            }
            for (Identifier identifier : clazz.interfaces()) {
                if (identifier instanceof NamespaceName) {
                    this.highlightNamespaceType((NamespaceName)identifier);
                    continue;
                }
                ClassHighlighting.this.highlight((ASTNode)identifier);
            }
            return true;
        }

        public boolean visit(TraitDeclaration trait) {
            ClassHighlighting.this.highlight((ASTNode)trait.getName());
            Expression superClass = trait.getSuperClass();
            if (superClass instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)superClass);
            } else if (superClass != null) {
                ClassHighlighting.this.highlight((ASTNode)superClass);
            }
            for (Identifier identifier : trait.interfaces()) {
                if (identifier instanceof NamespaceName) {
                    this.highlightNamespaceType((NamespaceName)identifier);
                    continue;
                }
                ClassHighlighting.this.highlight((ASTNode)identifier);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation clazz) {
            Expression name = clazz.getClassName().getName();
            if (name instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)name, true);
            } else if (name instanceof Identifier) {
                if (ClassHighlighting.SELF.equalsIgnoreCase(((Identifier)name).getName()) || ClassHighlighting.CLASS.equalsIgnoreCase(((Identifier)name).getName()) || ClassHighlighting.PARENT.equalsIgnoreCase(((Identifier)name).getName())) {
                    return true;
                }
                ClassHighlighting.this.highlight((ASTNode)name);
            }
            return true;
        }

        public boolean visit(InstanceOfExpression instanceOfExpression) {
            Expression name = instanceOfExpression.getClassName().getName();
            if (name instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)name);
            } else if (name instanceof Identifier) {
                ClassHighlighting.this.highlight((ASTNode)name);
            }
            return true;
        }

        public boolean visit(FormalParameter param) {
            Expression type = param.getParameterType();
            if (type instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)type);
            } else if (type instanceof Identifier && !PHPSimpleTypes.isHintable((String)((Identifier)type).getName(), (PHPVersion)param.getAST().apiLevel())) {
                ClassHighlighting.this.highlight((ASTNode)type);
            }
            return true;
        }

        public boolean visit(FieldsDeclaration fieldsDeclaration) {
            Expression type = fieldsDeclaration.getFieldsType();
            if (type instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)type);
            } else if (type instanceof Identifier && !PHPSimpleTypes.isHintable((String)((Identifier)type).getName(), (PHPVersion)fieldsDeclaration.getAST().apiLevel())) {
                ClassHighlighting.this.highlight((ASTNode)type);
            }
            return true;
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration.getReturnType() == null) {
                return true;
            }
            Identifier type = functionDeclaration.getReturnType();
            if (type instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)type);
            } else if (type != null && !PHPSimpleTypes.isHintable((String)type.getName(), (PHPVersion)functionDeclaration.getAST().apiLevel())) {
                ClassHighlighting.this.highlight((ASTNode)type);
            }
            return true;
        }

        public boolean visit(TraitUseStatement node) {
            List traitList = node.getTraitList();
            for (NamespaceName namespaceName : traitList) {
                this.highlightNamespaceType(namespaceName);
            }
            List tsList = node.getTsList();
            for (TraitStatement traitStatement : tsList) {
                FullyQualifiedTraitMethodReference reference;
                TraitAliasStatement statement;
                if (traitStatement instanceof TraitAliasStatement) {
                    statement = (TraitAliasStatement)traitStatement;
                    if (!(statement.getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference)) continue;
                    reference = (FullyQualifiedTraitMethodReference)statement.getAlias().getTraitMethod();
                    this.highlightNamespaceType(reference.getClassName());
                    continue;
                }
                if (!(traitStatement instanceof TraitPrecedenceStatement)) continue;
                statement = (TraitPrecedenceStatement)traitStatement;
                reference = statement.getPrecedence().getMethodReference();
                this.highlightNamespaceType(reference.getClassName());
                traitList = statement.getPrecedence().getTrList();
                for (NamespaceName namespaceName : traitList) {
                    this.highlightNamespaceType(namespaceName);
                }
            }
            return false;
        }

        public boolean visit(CatchClause catchStatement) {
            catchStatement.getClassNames().stream().forEach(e -> {
                if (e instanceof NamespaceName) {
                    this.highlightNamespaceType((NamespaceName)e);
                } else if (e instanceof Identifier) {
                    ClassHighlighting.this.highlight((ASTNode)e);
                }
            });
            return true;
        }

        public boolean visit(StaticConstantAccess classConstant) {
            this.highlightStatic((StaticDispatch)classConstant);
            return true;
        }

        public boolean visit(StaticFieldAccess staticMember) {
            this.highlightStatic((StaticDispatch)staticMember);
            return true;
        }

        public boolean visit(StaticMethodInvocation staticMethodInvocation) {
            this.highlightStatic((StaticDispatch)staticMethodInvocation);
            return true;
        }

        private void highlightStatic(StaticDispatch dispatch) {
            Expression className = dispatch.getClassName();
            if (className instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)className, true);
            } else if (className instanceof Identifier && !ClassHighlighting.SELF.equalsIgnoreCase(((Identifier)className).getName()) && !ClassHighlighting.PARENT.equalsIgnoreCase(((Identifier)className).getName())) {
                ClassHighlighting.this.highlight((ASTNode)className);
            }
        }

        private void highlightNamespaceType(NamespaceName name) {
            this.highlightNamespaceType(name, false);
        }

        private void highlightNamespaceType(NamespaceName name, boolean excludeSelf) {
            List segments = name.segments();
            if (segments.size() > 0) {
                Identifier segment = (Identifier)segments.get(segments.size() - 1);
                if (!(segments.size() <= 1 && !name.isGlobal() && (PHPSimpleTypes.isHintable((String)segment.getName(), (PHPVersion)name.getAST().apiLevel()) || excludeSelf && ClassHighlighting.SELF.equalsIgnoreCase(segment.getName()) || ClassHighlighting.PARENT.equalsIgnoreCase(segment.getName())))) {
                    ClassHighlighting.this.highlight((ASTNode)segment);
                }
            }
        }
    }
}

