/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractSourceCreator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalizableLinkageCreator
extends AbstractSourceCreator {
    private final Map<String, String> implCache = new HashMap<String, String>();

    LocalizableLinkageCreator() {
    }

    static Map<String, JClassType> findDerivedClasses(TreeLogger logger, JClassType baseClass) throws UnableToCompleteException {
        HashMap<String, JClassType> matchingClasses = new HashMap<String, JClassType>();
        if (baseClass.isInterface() == null && !baseClass.isAbstract()) {
            matchingClasses.put("default", baseClass);
        }
        String baseName = baseClass.getSimpleSourceName();
        JClassType[] x = baseClass.getSubtypes();
        for (int i = 0; i < x.length; ++i) {
            boolean isDefault;
            boolean matches;
            JClassType subType = x[i];
            if (subType.isInterface() != null || subType.isAbstract()) continue;
            String name = subType.getSimpleSourceName();
            int localeIndex = name.indexOf(95);
            String subTypeBaseName = name;
            if (localeIndex != -1) {
                subTypeBaseName = name.substring(0, localeIndex);
            }
            if (!(matches = subTypeBaseName.equals(baseName))) continue;
            boolean bl = isDefault = localeIndex == -1 || localeIndex == name.length() - 1 || "default".equals(name.substring(localeIndex + 1));
            if (isDefault) {
                JClassType defaultClass = (JClassType)matchingClasses.get("default");
                if (defaultClass != null) {
                    throw LocalizableLinkageCreator.error(logger, defaultClass + " and " + baseName + " are both potential default classes for " + baseClass);
                }
                matchingClasses.put("default", subType);
                continue;
            }
            String localeSubString = name.substring(localeIndex + 1);
            JClassType dopClass = (JClassType)matchingClasses.get(localeSubString);
            if (dopClass != null) {
                throw LocalizableLinkageCreator.error(logger, dopClass.getQualifiedSourceName() + " and " + subType.getQualifiedSourceName() + " are both potential matches to " + baseClass + " in locale " + localeSubString);
            }
            matchingClasses.put(localeSubString, subType);
        }
        return matchingClasses;
    }

    String linkWithImplClass(TreeLogger logger, JClassType baseClass, GwtLocale locale) throws UnableToCompleteException {
        String baseName = baseClass.getQualifiedSourceName();
        String className = this.implCache.get(baseName + ((Object)locale).toString());
        if (className != null) {
            return className;
        }
        if (baseClass.getName().indexOf(95) != -1) {
            throw LocalizableLinkageCreator.error(logger, "Cannot have a _ in the base localizable class " + baseClass);
        }
        Map<String, JClassType> matchingClasses = LocalizableLinkageCreator.findDerivedClasses(logger, baseClass);
        JClassType result = null;
        for (GwtLocale search : locale.getCompleteSearchList()) {
            result = matchingClasses.get(((Object)search).toString());
            if (result == null) continue;
            className = result.getQualifiedSourceName();
            this.implCache.put(baseName + ((Object)locale).toString(), className);
            return className;
        }
        throw LocalizableLinkageCreator.error(logger, "Cannot find a class to bind to argument type " + baseClass.getQualifiedSourceName());
    }
}

