/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.json.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.json.client.JSONValue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends JSONValue {
    private final JavaScriptObject jsObject;

    private static JavaScriptObject unwrap(JSONObject value) {
        return value.jsObject;
    }

    public JSONObject() {
        this(JavaScriptObject.createObject());
    }

    public JSONObject(JavaScriptObject jsValue) {
        this.jsObject = jsValue;
    }

    public native boolean containsKey(String var1);

    public boolean equals(Object other) {
        if (!(other instanceof JSONObject)) {
            return false;
        }
        return this.jsObject.equals(((JSONObject)other).jsObject);
    }

    public JSONValue get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get0(key);
    }

    public JavaScriptObject getJavaScriptObject() {
        return this.jsObject;
    }

    public int hashCode() {
        return this.jsObject.hashCode();
    }

    @Override
    public JSONObject isObject() {
        return this;
    }

    public Set<String> keySet() {
        final String[] keys = this.computeKeys();
        return new AbstractSet<String>(){

            @Override
            public boolean contains(Object o) {
                return o instanceof String && JSONObject.this.containsKey((String)o);
            }

            @Override
            public Iterator<String> iterator() {
                return Arrays.asList(keys).iterator();
            }

            @Override
            public int size() {
                return keys.length;
            }
        };
    }

    public JSONValue put(String key, JSONValue jsonValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        JSONValue previous = this.get(key);
        this.put0(key, jsonValue);
        return previous;
    }

    public int size() {
        return this.computeSize();
    }

    @Override
    public String toString() {
        String[] keys;
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (String key : keys = this.computeKeys()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(JsonUtils.escapeValue(key));
            sb.append(":");
            sb.append(this.get(key));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    native JavaScriptObject getUnwrapper();

    private native void addAllKeys(Collection<String> var1);

    private String[] computeKeys() {
        if (GWT.isScript()) {
            return this.computeKeys0(new String[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        this.addAllKeys(result);
        return result.toArray(new String[result.size()]);
    }

    private native String[] computeKeys0(String[] var1);

    private native int computeSize();

    private native JSONValue get0(String var1);

    private native void put0(String var1, JSONValue var2);
}

