/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.DevModeBase;
import com.google.gwt.dev.GWTCompiler;
import com.google.gwt.dev.GWTShell;
import com.google.gwt.dev.LegacyCompilerOptions;
import com.google.gwt.dev.cfg.BindingProperty;
import com.google.gwt.dev.cfg.Condition;
import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.dev.cfg.ModuleDefLoader;
import com.google.gwt.dev.cfg.Properties;
import com.google.gwt.dev.cfg.Property;
import com.google.gwt.dev.javac.CompilationState;
import com.google.gwt.dev.javac.CompilationUnit;
import com.google.gwt.dev.util.arg.ArgHandlerDisableAggressiveOptimization;
import com.google.gwt.dev.util.arg.ArgHandlerDisableCastChecking;
import com.google.gwt.dev.util.arg.ArgHandlerDisableClassMetadata;
import com.google.gwt.dev.util.arg.ArgHandlerDraftCompile;
import com.google.gwt.dev.util.arg.ArgHandlerEnableAssertions;
import com.google.gwt.dev.util.arg.ArgHandlerLocalWorkers;
import com.google.gwt.dev.util.arg.ArgHandlerLogLevel;
import com.google.gwt.dev.util.arg.ArgHandlerScriptStyle;
import com.google.gwt.dev.util.arg.OptionAggressivelyOptimize;
import com.google.gwt.dev.util.arg.OptionDisableCastChecking;
import com.google.gwt.dev.util.arg.OptionDisableClassMetadata;
import com.google.gwt.dev.util.arg.OptionDraftCompile;
import com.google.gwt.dev.util.arg.OptionEnableAssertions;
import com.google.gwt.dev.util.arg.OptionLocalWorkers;
import com.google.gwt.dev.util.arg.OptionLogLevel;
import com.google.gwt.dev.util.arg.OptionScriptStyle;
import com.google.gwt.junit.BatchingStrategy;
import com.google.gwt.junit.ClassBatchingStrategy;
import com.google.gwt.junit.CompileStrategy;
import com.google.gwt.junit.DoNotRunWith;
import com.google.gwt.junit.JUnitFatalLaunchException;
import com.google.gwt.junit.JUnitMessageQueue;
import com.google.gwt.junit.ModuleBatchingStrategy;
import com.google.gwt.junit.NoBatchingStrategy;
import com.google.gwt.junit.ParallelCompileStrategy;
import com.google.gwt.junit.Platform;
import com.google.gwt.junit.PreCompileStrategy;
import com.google.gwt.junit.RunStyle;
import com.google.gwt.junit.RunStyleHtmlUnit;
import com.google.gwt.junit.RunStyleManual;
import com.google.gwt.junit.SimpleCompileStrategy;
import com.google.gwt.junit.client.GWTTestCase;
import com.google.gwt.junit.client.TimeoutException;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.junit.client.impl.JUnitResult;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerInt;
import com.google.gwt.util.tools.ArgHandlerString;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitShell
extends GWTShell {
    static final int TEST_BEGIN_TIMEOUT_MILLIS = 60000;
    private static final String PROP_GWT_ARGS = "gwt.args";
    private static JUnitShell unitTestShell;
    private long baseTestMethodTimeoutMillis;
    private BatchingStrategy batchingStrategy = new NoBatchingStrategy();
    private CompileStrategy compileStrategy = new SimpleCompileStrategy(this);
    private CompilationState currentCompilationState;
    private ModuleDef currentModule;
    private JUnitHost.TestInfo currentTestInfo;
    private boolean developmentMode = true;
    private boolean firstLaunch = true;
    private boolean lastLaunchFailed;
    private ModuleDef lastModule;
    private JUnitMessageQueue messageQueue;
    private UnableToCompleteException pendingException;
    private String[] remoteUserAgents;
    private RunStyle runStyle = null;
    private String runStyleName = "HtmlUnit";
    private boolean shouldAutoGenerateResources = true;
    private boolean standardsMode = false;
    private long testBatchingMethodTimeoutMillis;
    private long testBeginTime;
    private long testBeginTimeout;
    private long testMethodTimeout;
    private int tries;

    public static JUnitMessageQueue getMessageQueue() {
        if (unitTestShell == null) {
            return null;
        }
        return JUnitShell.unitTestShell.messageQueue;
    }

    public static String[] getRemoteUserAgents() {
        if (unitTestShell == null) {
            return null;
        }
        return JUnitShell.unitTestShell.remoteUserAgents;
    }

    public static boolean mustNotExecuteTest(JUnitHost.TestInfo testInfo) {
        if (unitTestShell == null) {
            throw new IllegalStateException("mustNotExecuteTest cannot be called before runTest()");
        }
        try {
            Class<?> testClass = TestCase.class.getClassLoader().loadClass(testInfo.getTestClass());
            return unitTestShell.mustNotExecuteTest(JUnitShell.getBannedPlatforms(testClass, testInfo.getTestMethod()));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load test class: " + testInfo.getTestClass());
        }
    }

    public static void runTest(GWTTestCase testCase, TestResult testResult) throws UnableToCompleteException {
        JUnitShell.getUnitTestShell().runTestImpl(testCase, testResult);
    }

    @Deprecated
    public static void runTest(String moduleName, TestCase testCase, TestResult testResult) throws UnableToCompleteException {
        JUnitShell.runTest(moduleName, testCase, testResult, ((GWTTestCase)testCase).getStrategy());
    }

    @Deprecated
    public static void runTest(String moduleName, TestCase testCase, TestResult testResult, Strategy strategy) throws UnableToCompleteException {
        GWTTestCase gwtTestCase = (GWTTestCase)testCase;
        assert (moduleName != null) : "moduleName cannot be null";
        assert (strategy != null) : "strategy cannot be null";
        assert (moduleName.equals(gwtTestCase.getModuleName())) : "moduleName does not match GWTTestCase#getModuleName()";
        assert (strategy.equals(gwtTestCase.getStrategy())) : "strategy does not match GWTTestCase#getStrategy()";
        JUnitShell.runTest(gwtTestCase, testResult);
    }

    private static JUnitFatalLaunchException checkTestClassInCurrentModule(CompilationState compilationState, String moduleName, TestCase testCase) {
        TypeOracle typeOracle = compilationState.getTypeOracle();
        String typeName = testCase.getClass().getName();
        JClassType foundType = typeOracle.findType(typeName = typeName.replace('$', '.'));
        if (foundType != null) {
            return null;
        }
        Map unitMap = compilationState.getCompilationUnitMap();
        CompilationUnit unit = (CompilationUnit)unitMap.get(typeName);
        String errMsg = unit == null ? "The test class '" + typeName + "' was not found in module '" + moduleName + "'; no compilation unit for that type was seen" : (unit.isError() ? "The test class '" + typeName + "' had compile errors; check log for details" : (!unit.isCompiled() ? "The test class '" + typeName + "' depends on a unit that had compile errors; check log for details" : "Unexpected error: the test class '" + typeName + "' appears to be valid, but no corresponding type was found in TypeOracle; please contact GWT support"));
        return new JUnitFatalLaunchException(errMsg);
    }

    private static Set<Platform> getBannedPlatforms(Class<?> testClass, String methodName) {
        EnumSet<Platform> bannedSet = EnumSet.noneOf(Platform.class);
        if (testClass.isAnnotationPresent(DoNotRunWith.class)) {
            bannedSet.addAll(Arrays.asList(testClass.getAnnotation(DoNotRunWith.class).value()));
        }
        try {
            Method testMethod = testClass.getMethod(methodName, new Class[0]);
            if (testMethod.isAnnotationPresent(DoNotRunWith.class)) {
                bannedSet.addAll(Arrays.asList(testMethod.getAnnotation(DoNotRunWith.class).value()));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return bannedSet;
    }

    private static JUnitShell getUnitTestShell() {
        if (unitTestShell == null) {
            unitTestShell = new JUnitShell();
            JUnitShell.unitTestShell.lastLaunchFailed = true;
            String[] args = unitTestShell.synthesizeArgs();
            ArgProcessor argProcessor = unitTestShell.new ArgProcessor();
            if (!argProcessor.processArgs(args)) {
                throw new JUnitFatalLaunchException("Error processing shell arguments");
            }
            JUnitShell.unitTestShell.options.setBindAddress("0.0.0.0");
            try {
                JUnitShell.unitTestShell.options.setConnectAddress(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                throw new JUnitFatalLaunchException("Unable to resolve my address");
            }
            if (!unitTestShell.startUp()) {
                throw new JUnitFatalLaunchException("Shell failed to start");
            }
            JUnitShell.unitTestShell.lastLaunchFailed = false;
        }
        unitTestShell.checkArgs();
        return unitTestShell;
    }

    private JUnitShell() {
        this.setRunTomcat(true);
        this.setHeadless(true);
    }

    public String getModuleUrl(String moduleName) {
        String localhost = this.runStyle.getLocalHostName();
        String url = "http://" + localhost + ":" + this.getPort() + "/" + moduleName + (this.standardsMode ? "/junit-standards.html" : "/junit.html");
        if (this.developmentMode) {
            url = url + "?gwt.codesvr=" + localhost + ":" + this.codeServerPort;
        }
        return url;
    }

    protected long checkForUpdatesInterval() {
        return 60000L;
    }

    protected boolean doStartup() {
        if (!super.doStartup()) {
            return false;
        }
        int numClients = this.createRunStyle(this.runStyleName);
        if (numClients < 0) {
            return false;
        }
        this.messageQueue = new JUnitMessageQueue(numClients);
        if (this.tries >= 1) {
            this.runStyle.setTries(this.tries);
        }
        if (!this.runStyle.setupMode(this.getTopLogger(), this.developmentMode)) {
            this.getTopLogger().log(TreeLogger.ERROR, "Run style does not support " + (this.developmentMode ? "development" : "production") + " mode");
            return false;
        }
        return true;
    }

    protected void ensureCodeServerListener() {
        if (this.developmentMode) {
            super.ensureCodeServerListener();
            this.listener.setIgnoreRemoteDeath(true);
        }
    }

    protected ModuleDef loadModule(TreeLogger logger, String moduleName, boolean refresh) throws UnableToCompleteException {
        return super.loadModule(logger, moduleName, false);
    }

    protected boolean notDone() {
        int activeClients = this.messageQueue.getNumClientsRetrievedTest(this.currentTestInfo);
        int expectedClients = this.messageQueue.getNumClients();
        if (this.firstLaunch && this.runStyle instanceof RunStyleManual) {
            String[] newClients = this.messageQueue.getNewClients();
            int printIndex = activeClients - newClients.length + 1;
            for (String newClient : newClients) {
                System.out.println(printIndex + " - " + newClient);
                ++printIndex;
            }
            if (activeClients != expectedClients) {
                return true;
            }
        }
        if (this.remoteUserAgents == null && this.messageQueue.getNumConnectedClients() == expectedClients) {
            this.remoteUserAgents = this.messageQueue.getUserAgents();
            String userAgentList = "";
            for (int i = 0; i < this.remoteUserAgents.length; ++i) {
                if (i > 0) {
                    userAgentList = userAgentList + ", ";
                }
                userAgentList = userAgentList + this.remoteUserAgents[i];
            }
            this.getTopLogger().log(TreeLogger.INFO, "All clients connected (Limiting future permutations to: " + userAgentList + ")");
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (activeClients >= expectedClients) {
            if (activeClients > expectedClients) {
                this.getTopLogger().log(TreeLogger.WARN, "Too many clients: expected " + expectedClients + ", found " + activeClients);
            }
            this.firstLaunch = false;
            this.lastModule = this.currentModule;
            if (this.testMethodTimeout == 0L) {
                this.testMethodTimeout = currentTimeMillis + this.testBatchingMethodTimeoutMillis;
            } else if (this.testMethodTimeout < currentTimeMillis) {
                double elapsed = (double)(currentTimeMillis - this.testBeginTime) / 1000.0;
                throw new TimeoutException("The browser did not complete the test method " + this.currentTestInfo.toString() + " in " + this.testBatchingMethodTimeoutMillis + "ms.\n  We have no results from:\n" + this.messageQueue.getWorkingClients(this.currentTestInfo) + "Actual time elapsed: " + elapsed + " seconds.\n");
            }
        } else if (this.testBeginTimeout < currentTimeMillis) {
            double elapsed = (double)(currentTimeMillis - this.testBeginTime) / 1000.0;
            throw new TimeoutException("The browser did not contact the server within 60000ms.\n" + this.messageQueue.getUnretrievedClients(this.currentTestInfo) + "\n Actual time elapsed: " + elapsed + " seconds.\n");
        }
        String[] interruptedHosts = this.runStyle.getInterruptedHosts();
        if (interruptedHosts != null) {
            StringBuilder msg = new StringBuilder();
            msg.append("A remote browser died a mysterious death.\n");
            msg.append("  We lost communication with:");
            for (String host : interruptedHosts) {
                msg.append("\n  ").append(host);
            }
            throw new TimeoutException(msg.toString());
        }
        if (this.messageQueue.hasResults(this.currentTestInfo)) {
            return false;
        }
        if (this.pendingException == null) {
            try {
                this.compileStrategy.maybeCompileAhead();
            }
            catch (UnableToCompleteException e) {
                this.pendingException = e;
            }
        }
        return true;
    }

    protected boolean shouldAutoGenerateResources() {
        return this.shouldAutoGenerateResources;
    }

    protected void warnAboutNoStartupUrls() {
    }

    void compileForWebMode(String moduleName, String ... userAgents) throws UnableToCompleteException {
        GWTCompiler.GWTCompilerOptionsImpl newOptions;
        Properties props;
        Property userAgent;
        ModuleDef module = ModuleDefLoader.loadFromClassPath((TreeLogger)this.getTopLogger(), (String)moduleName, (boolean)false);
        if (userAgents != null && userAgents.length > 0 && (userAgent = (props = module.getProperties()).find("user.agent")) instanceof BindingProperty) {
            BindingProperty bindingProperty = (BindingProperty)userAgent;
            bindingProperty.setAllowedValues((Condition)bindingProperty.getRootCondition(), userAgents);
        }
        if (!new GWTCompiler((LegacyCompilerOptions)(newOptions = new GWTCompiler.GWTCompilerOptionsImpl((LegacyCompilerOptions)this.options))).run(this.getTopLogger(), new ModuleDef[]{module})) {
            throw new UnableToCompleteException();
        }
    }

    void maybeCompileForWebMode(String moduleName, String ... userAgents) throws UnableToCompleteException {
        if (!this.developmentMode || !this.shouldAutoGenerateResources) {
            this.compileForWebMode(moduleName, userAgents);
        }
    }

    void setHeadlessAccessor(boolean headlessMode) {
        this.setHeadless(headlessMode);
    }

    @Deprecated
    void setNumClients(int numClients) {
        throw new UnsupportedOperationException("This method should be deleted.");
    }

    void setStandardsMode(boolean standardsMode) {
        this.standardsMode = standardsMode;
    }

    private void checkArgs() {
        if (this.runStyle.getTries() > 1 && !(this.batchingStrategy instanceof NoBatchingStrategy)) {
            throw new JUnitFatalLaunchException("Batching does not work with tries > 1");
        }
    }

    private int createRunStyle(String runStyleName) {
        String args = null;
        String name = runStyleName;
        int colon = name.indexOf(58);
        if (colon >= 0) {
            args = name.substring(colon + 1);
            name = name.substring(0, colon);
        }
        if (name.indexOf(46) < 0) {
            name = RunStyle.class.getName() + name;
        }
        Exception caught = null;
        try {
            Class<?> clazz = Class.forName(name);
            Class<RunStyle> runStyleClass = clazz.asSubclass(RunStyle.class);
            Constructor<RunStyle> ctor = runStyleClass.getConstructor(JUnitShell.class);
            this.runStyle = ctor.newInstance(new Object[]{this});
            return this.runStyle.initialize(args);
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to create runStyle \"" + runStyleName + "\"";
            msg = runStyleName.indexOf(46) < 0 && runStyleName.length() > 0 && Character.isLowerCase(runStyleName.charAt(0)) ? msg + " - did you mean \"" + Character.toUpperCase(runStyleName.charAt(0)) + runStyleName.substring(1) + "\"?" : msg + " -- is it spelled correctly?";
            this.getTopLogger().log(TreeLogger.ERROR, msg);
            return -1;
        }
        catch (SecurityException e) {
            caught = e;
        }
        catch (NoSuchMethodException e) {
            caught = e;
        }
        catch (IllegalArgumentException e) {
            caught = e;
        }
        catch (InstantiationException e) {
            caught = e;
        }
        catch (IllegalAccessException e) {
            caught = e;
        }
        catch (InvocationTargetException e) {
            caught = e;
        }
        this.getTopLogger().log(TreeLogger.ERROR, "Unable to create runStyle \"" + runStyleName + "\"", (Throwable)caught);
        return -1;
    }

    private boolean mustNotExecuteTest(Set<Platform> bannedPlatforms) {
        return this.runStyle instanceof RunStyleHtmlUnit && bannedPlatforms.contains((Object)Platform.HtmlUnit);
    }

    private boolean mustRetry(int numTries) {
        if (numTries >= this.runStyle.getTries()) {
            return false;
        }
        assert (this.batchingStrategy instanceof NoBatchingStrategy);
        return true;
    }

    private void processTestResult(TestCase testCase, TestResult testResult, Strategy strategy) {
        Map<JUnitMessageQueue.ClientStatus, JUnitResult> results = this.messageQueue.getResults(this.currentTestInfo);
        assert (results != null);
        assert (results.size() == this.messageQueue.getNumClients()) : results.size() + " != " + this.messageQueue.getNumClients();
        for (Map.Entry<JUnitMessageQueue.ClientStatus, JUnitResult> entry : results.entrySet()) {
            JUnitMessageQueue.ClientStatus client = entry.getKey();
            JUnitResult result = entry.getValue();
            assert (result != null);
            Throwable exception = result.getException();
            if (exception != null) {
                String msg = "Remote test failed at " + client.getDesc();
                if (exception instanceof AssertionFailedError) {
                    String oldMessage = exception.getMessage();
                    if (oldMessage != null) {
                        msg = msg + "\n" + exception.getMessage();
                    }
                    AssertionFailedError newException = new AssertionFailedError(msg);
                    newException.setStackTrace(exception.getStackTrace());
                    newException.initCause(exception.getCause());
                    exception = newException;
                } else {
                    exception = new RuntimeException(msg, exception);
                }
            }
            if (exception instanceof AssertionFailedError) {
                testResult.addFailure((Test)testCase, (AssertionFailedError)exception);
            } else if (exception != null) {
                if (exception instanceof JUnitFatalLaunchException) {
                    this.lastLaunchFailed = true;
                }
                testResult.addError((Test)testCase, exception);
            }
            strategy.processResult(testCase, result);
        }
    }

    private void runTestImpl(GWTTestCase testCase, TestResult testResult) throws UnableToCompleteException {
        this.runTestImpl(testCase, testResult, 0);
    }

    private void runTestImpl(GWTTestCase testCase, TestResult testResult, int numTries) throws UnableToCompleteException {
        boolean mustRetry;
        block16: {
            boolean sameTest;
            this.testBatchingMethodTimeoutMillis = (long)this.batchingStrategy.getTimeoutMultiplier() * this.baseTestMethodTimeoutMillis;
            if (this.mustNotExecuteTest(JUnitShell.getBannedPlatforms(((Object)((Object)testCase)).getClass(), testCase.getName()))) {
                return;
            }
            if (this.lastLaunchFailed) {
                throw new UnableToCompleteException();
            }
            String moduleName = testCase.getModuleName();
            String syntheticModuleName = testCase.getSyntheticModuleName();
            Strategy strategy = testCase.getStrategy();
            boolean bl = sameTest = this.currentModule != null && syntheticModuleName.equals(this.currentModule.getName());
            if (sameTest && this.lastLaunchFailed) {
                throw new UnableToCompleteException();
            }
            if (!sameTest) {
                this.currentModule = this.compileStrategy.maybeCompileModule(moduleName, syntheticModuleName, strategy, this.batchingStrategy, this.getTopLogger());
                this.currentCompilationState = this.currentModule.getCompilationState(this.getTopLogger());
            }
            assert (this.currentModule != null);
            JUnitFatalLaunchException launchException = JUnitShell.checkTestClassInCurrentModule(this.currentCompilationState, moduleName, testCase);
            if (launchException != null) {
                testResult.addError((Test)testCase, (Throwable)launchException);
                return;
            }
            this.currentTestInfo = new JUnitHost.TestInfo(this.currentModule.getName(), ((Object)((Object)testCase)).getClass().getName(), testCase.getName());
            ++numTries;
            if (this.messageQueue.hasResults(this.currentTestInfo)) {
                this.processTestResult(testCase, testResult, strategy);
                return;
            }
            this.compileStrategy.maybeAddTestBlockForCurrentTest(testCase, this.batchingStrategy);
            try {
                if (this.firstLaunch) {
                    this.runStyle.launchModule(this.currentModule.getName());
                }
            }
            catch (UnableToCompleteException e) {
                this.lastLaunchFailed = true;
                testResult.addError((Test)testCase, (Throwable)new JUnitFatalLaunchException(e));
                return;
            }
            mustRetry = this.mustRetry(numTries);
            try {
                this.testBeginTime = System.currentTimeMillis();
                this.testBeginTimeout = this.testBeginTime + 60000L;
                this.testMethodTimeout = 0L;
                while (this.notDone()) {
                    this.messageQueue.waitForResults(1000);
                }
                if (!mustRetry && this.pendingException != null) {
                    UnableToCompleteException e = this.pendingException;
                    this.pendingException = null;
                    throw e;
                }
            }
            catch (TimeoutException e) {
                if (mustRetry) break block16;
                this.lastLaunchFailed = true;
                testResult.addError((Test)testCase, (Throwable)e);
                return;
            }
        }
        if (mustRetry && this.messageQueue.needsRerunning(this.currentTestInfo)) {
            this.messageQueue.removeResults(this.currentTestInfo);
            this.getTopLogger().log(TreeLogger.WARN, this.currentTestInfo + " is being retried, retry attempt = " + numTries);
            this.runTestImpl(testCase, testResult, numTries);
            return;
        }
        assert (this.messageQueue.hasResults(this.currentTestInfo));
        this.processTestResult(testCase, testResult, testCase.getStrategy());
    }

    private String[] synthesizeArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        String args = System.getProperty(PROP_GWT_ARGS);
        if (args != null) {
            Pattern pattern = Pattern.compile("[^\\s\"]+|\"[^\"\\\\]*(\\\\.[^\"\\\\]*)*\"");
            Matcher matcher = pattern.matcher(args);
            Pattern quotedArgsPattern = Pattern.compile("^([\"'])(.*)([\"'])$");
            while (matcher.find()) {
                String arg = matcher.group();
                Matcher qmatcher = quotedArgsPattern.matcher(arg);
                if (qmatcher.matches()) {
                    argList.add(qmatcher.group(2));
                    continue;
                }
                argList.add(arg);
            }
        }
        return argList.toArray(new String[argList.size()]);
    }

    static /* synthetic */ String[] access$1902(JUnitShell x0, String[] x1) {
        x0.remoteUserAgents = x1;
        return x1;
    }

    class ArgProcessor
    extends GWTShell.ArgProcessor {
        public ArgProcessor() {
            super(JUnitShell.this.options, true, true);
            this.registerHandler((ArgHandler)new ArgHandlerScriptStyle((OptionScriptStyle)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerEnableAssertions((OptionEnableAssertions)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerDisableAggressiveOptimization((OptionAggressivelyOptimize)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerDisableClassMetadata((OptionDisableClassMetadata)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerDisableCastChecking((OptionDisableCastChecking)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerDraftCompile((OptionDraftCompile)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new ArgHandlerLocalWorkers((OptionLocalWorkers)JUnitShell.this.options));
            this.registerHandler((ArgHandler)new DevModeBase.ArgHandlerPort((DevModeBase.OptionPort)JUnitShell.this.options){

                public String[] getDefaultArgs() {
                    return new String[]{"-port", "auto"};
                }
            });
            this.registerHandler((ArgHandler)new DevModeBase.ArgHandlerCodeServerPort((DevModeBase.OptionCodeServerPort)JUnitShell.this.options){

                public String[] getDefaultArgs() {
                    return new String[]{this.getTag(), "auto"};
                }
            });
            this.registerHandler((ArgHandler)new DevModeBase.ArgHandlerBindAddress((DevModeBase.OptionBindAddress)JUnitShell.this.options){

                public String[] getDefaultArgs() {
                    return null;
                }

                public boolean isUndocumented() {
                    return true;
                }

                public boolean setString(String value) {
                    System.err.println("-bindAddress is not supported for JUnitShell");
                    return false;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerLogLevel((OptionLogLevel)JUnitShell.this.options){

                protected TreeLogger.Type getDefaultLogLevel() {
                    return TreeLogger.WARN;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerFlag(){

                public String getPurpose() {
                    return "Causes your test to run in -noserver development mode (defaults to development mode)";
                }

                public String getTag() {
                    return "-noserver";
                }

                public boolean setFlag() {
                    JUnitShell.this.shouldAutoGenerateResources = false;
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerFlag(){

                public String getPurpose() {
                    return "Synonym for -prod (deprecated)";
                }

                public String getTag() {
                    return "-web";
                }

                public boolean isUndocumented() {
                    return true;
                }

                public boolean setFlag() {
                    JUnitShell.this.developmentMode = false;
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerFlag(){

                public String getPurpose() {
                    return "Causes your test to run in production (compiled) mode (defaults to development mode)";
                }

                public String getTag() {
                    return "-prod";
                }

                public boolean setFlag() {
                    JUnitShell.this.developmentMode = false;
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerInt(){

                public String[] getDefaultArgs() {
                    return new String[]{this.getTag(), "5"};
                }

                public String getPurpose() {
                    return "Set the test method timeout, in minutes";
                }

                public String getTag() {
                    return "-testMethodTimeout";
                }

                public String[] getTagArgs() {
                    return new String[]{"minutes"};
                }

                public boolean isUndocumented() {
                    return false;
                }

                public void setInt(int minutes) {
                    JUnitShell.this.baseTestMethodTimeoutMillis = minutes * 60 * 1000;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerString(){

                public String getPurpose() {
                    return "Selects the runstyle to use for this test.  The name is a suffix of com.google.gwt.junit.RunStyle or is a fully qualified class name, and may be followed with a colon and an argument for this runstyle.  The specified class mustextend RunStyle.";
                }

                public String getTag() {
                    return "-runStyle";
                }

                public String[] getTagArgs() {
                    return new String[]{"runstyle[:args]"};
                }

                public boolean isUndocumented() {
                    return false;
                }

                public boolean setString(String runStyleArg) {
                    JUnitShell.this.runStyleName = runStyleArg;
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerString(){

                public String getPurpose() {
                    return "Configure batch execution of tests";
                }

                public String getTag() {
                    return "-batch";
                }

                public String[] getTagArgs() {
                    return new String[]{"none|class|module"};
                }

                public boolean isUndocumented() {
                    return true;
                }

                public boolean setString(String str) {
                    if (str.equals("none")) {
                        JUnitShell.this.batchingStrategy = new NoBatchingStrategy();
                    } else if (str.equals("class")) {
                        JUnitShell.this.batchingStrategy = new ClassBatchingStrategy();
                    } else if (str.equals("module")) {
                        JUnitShell.this.batchingStrategy = new ModuleBatchingStrategy();
                    } else {
                        return false;
                    }
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerFlag(){

                public String getPurpose() {
                    return "Causes the log window and browser windows to be displayed; useful for debugging";
                }

                public String getTag() {
                    return "-notHeadless";
                }

                public boolean setFlag() {
                    JUnitShell.this.setHeadlessAccessor(false);
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerString(){

                public String getPurpose() {
                    return "Precompile modules as tests are running (speeds up remote tests but requires more memory)";
                }

                public String getTag() {
                    return "-precompile";
                }

                public String[] getTagArgs() {
                    return new String[]{"simple|all|parallel"};
                }

                public boolean isUndocumented() {
                    return true;
                }

                public boolean setString(String str) {
                    if (str.equals("simple")) {
                        JUnitShell.this.compileStrategy = new SimpleCompileStrategy(JUnitShell.this);
                    } else if (str.equals("all")) {
                        JUnitShell.this.compileStrategy = new PreCompileStrategy(JUnitShell.this);
                    } else if (str.equals("parallel")) {
                        JUnitShell.this.compileStrategy = new ParallelCompileStrategy(JUnitShell.this);
                    } else {
                        return false;
                    }
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerFlag(){

                public String getPurpose() {
                    return "Use CSS standards mode (rather than quirks mode) for the hosting page";
                }

                public String getTag() {
                    return "-standardsMode";
                }

                public boolean setFlag() {
                    JUnitShell.this.setStandardsMode(true);
                    return true;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerInt(){

                public String getPurpose() {
                    return "EXPERIMENTAL: Sets the maximum number of attempts for running each test method";
                }

                public String getTag() {
                    return "-Xtries";
                }

                public String[] getTagArgs() {
                    return new String[]{"1"};
                }

                public boolean isRequired() {
                    return false;
                }

                public boolean isUndocumented() {
                    return false;
                }

                public void setInt(int value) {
                    JUnitShell.this.tries = value;
                }
            });
            this.registerHandler((ArgHandler)new ArgHandlerString(){

                public String getPurpose() {
                    return "Specify the user agents to reduce the number of permutations for remote browser tests; e.g. ie6,ie8,safari,gecko,gecko1_8,opera";
                }

                public String getTag() {
                    return "-userAgents";
                }

                public String[] getTagArgs() {
                    return new String[]{"userAgents"};
                }

                public boolean setString(String str) {
                    JUnitShell.access$1902(JUnitShell.this, str.split(","));
                    for (int i = 0; i < JUnitShell.this.remoteUserAgents.length; ++i) {
                        ((JUnitShell)JUnitShell.this).remoteUserAgents[i] = JUnitShell.this.remoteUserAgents[i].trim();
                    }
                    return true;
                }
            });
        }
    }

    public static interface Strategy {
        public String getModuleInherit();

        public String getSyntheticModuleExtension();

        public void processModule(ModuleDef var1);

        public void processResult(TestCase var1, JUnitResult var2);
    }
}

