/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.client;

import com.google.gwt.dev.cfg.ModuleDef;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.PropertyDefiningStrategy;
import com.google.gwt.junit.client.impl.JUnitHost;
import com.google.gwt.junit.client.impl.JUnitResult;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestResult;

public abstract class GWTTestCase
extends TestCase {
    public static final Map<String, TestModuleInfo> ALL_GWT_TESTS = new LinkedHashMap<String, TestModuleInfo>();
    private static final Object ALL_GWT_TESTS_LOCK = new Object();
    protected TestResult testResult = null;
    private JUnitShell.Strategy strategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getAllTestModuleNames() {
        Object object = ALL_GWT_TESTS_LOCK;
        synchronized (object) {
            return ALL_GWT_TESTS.keySet().toArray(new String[ALL_GWT_TESTS.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModuleCount() {
        Object object = ALL_GWT_TESTS_LOCK;
        synchronized (object) {
            return ALL_GWT_TESTS.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestModuleInfo getTestsForModule(String syntheticModuleName) {
        Object object = ALL_GWT_TESTS_LOCK;
        synchronized (object) {
            return ALL_GWT_TESTS.get(syntheticModuleName);
        }
    }

    @Deprecated
    public final void addCheckpoint(String msg) {
    }

    public boolean catchExceptions() {
        return true;
    }

    @Deprecated
    public final void clearCheckpoints() {
    }

    @Deprecated
    public final String[] getCheckpoints() {
        return null;
    }

    public abstract String getModuleName();

    public JUnitShell.Strategy getStrategy() {
        if (this.strategy == null) {
            this.strategy = this.createStrategy();
        }
        return this.strategy;
    }

    public final String getSyntheticModuleName() {
        return this.getModuleName() + "." + this.getStrategy().getSyntheticModuleExtension();
    }

    public final void run(TestResult result) {
        this.testResult = result;
        super.run(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        super.setName(name);
        Object object = ALL_GWT_TESTS_LOCK;
        synchronized (object) {
            String syntheticModuleName = this.getSyntheticModuleName();
            TestModuleInfo moduleInfo = ALL_GWT_TESTS.get(syntheticModuleName);
            if (moduleInfo == null) {
                moduleInfo = new TestModuleInfo(this.getModuleName(), syntheticModuleName, this.getStrategy());
                ALL_GWT_TESTS.put(syntheticModuleName, moduleInfo);
            }
            moduleInfo.getTests().add(new JUnitHost.TestInfo(syntheticModuleName, ((Object)((Object)this)).getClass().getName(), this.getName()));
        }
    }

    protected JUnitShell.Strategy createStrategy() {
        return new PropertyDefiningStrategy(this);
    }

    protected final void delayTestFinish(int timeoutMillis) {
    }

    protected final void finishTest() {
    }

    protected void gwtSetUp() throws Exception {
    }

    protected void gwtTearDown() throws Exception {
    }

    protected void runTest() throws Throwable {
        if (this.getName() == null) {
            throw new IllegalArgumentException("GWTTestCases require a name; \"" + this.toString() + "\" has none.  Perhaps you used TestSuite.addTest() instead of addTestClass()?");
        }
        String moduleName = this.getModuleName();
        if (moduleName != null) {
            JUnitShell.runTest(this, this.testResult);
        } else {
            super.runTest();
        }
    }

    protected final void setUp() throws Exception {
    }

    protected boolean supportsAsync() {
        return true;
    }

    protected final void tearDown() throws Exception {
    }

    public static class BaseStrategy
    implements JUnitShell.Strategy {
        public String getModuleInherit() {
            return "com.google.gwt.junit.JUnit";
        }

        public String getSyntheticModuleExtension() {
            return "JUnit";
        }

        public void processModule(ModuleDef module) {
        }

        public void processResult(TestCase testCase, JUnitResult result) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TestModuleInfo {
        private String moduleName;
        private String syntheticModuleName;
        private JUnitShell.Strategy strategy;
        private Set<JUnitHost.TestInfo> tests = new LinkedHashSet<JUnitHost.TestInfo>();

        public TestModuleInfo(String moduleName, String syntheticModuleName, JUnitShell.Strategy strategy) {
            this.moduleName = moduleName;
            this.syntheticModuleName = syntheticModuleName;
            this.strategy = strategy;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public JUnitShell.Strategy getStrategy() {
            return this.strategy;
        }

        public String getSyntheticModuleName() {
            return this.syntheticModuleName;
        }

        public Set<JUnitHost.TestInfo> getTests() {
            return this.tests;
        }
    }
}

